/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import java.security.PrivateKey;
import java.security.cert.Certificate;
import org.jpedal.io.DecryptionFactory;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.io.PdfReader;

public class FileAccess {
    Certificate certificate;
    PrivateKey key;

    public boolean isFileViewable(PdfObjectReader currentPdfFile) {
        if (currentPdfFile != null) {
            PdfFileReader objectReader = currentPdfFile.getObjectReader();
            DecryptionFactory decryption = objectReader.getDecryptionObject();
            return decryption == null || decryption.getBooleanValue(100) || this.certificate != null;
        }
        return false;
    }

    public boolean isPasswordSupplied(PdfObjectReader currentPdfFile) {
        if (currentPdfFile != null) {
            PdfFileReader objectReader = currentPdfFile.getObjectReader();
            DecryptionFactory decryption = objectReader.getDecryptionObject();
            return decryption != null && (decryption.getBooleanValue(104) || this.certificate != null);
        }
        return false;
    }

    public void setUserEncryption(Certificate certificate, PrivateKey key) {
        this.certificate = certificate;
        this.key = key;
    }

    public PdfObjectReader getNewReader() {
        PdfReader currentPdfFile = this.certificate != null ? new PdfReader(this.certificate, this.key) : new PdfReader();
        return currentPdfFile;
    }
}

