/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class LabColorSpace
extends GenericColorSpace {
    private static final long serialVersionUID = 9204166205367322647L;
    private int r;
    private int g;
    private int b;
    private float lastL = -1.0f;
    private float lastA = 65536.0f;
    private float lastBstar;
    private Map cache = new HashMap();
    private static final float C1 = 0.12841855f;
    private static final float C2 = 0.13793103f;
    private static final float C3 = 0.20689656f;
    private static final float C4 = 0.39215687f;
    private static final float C5 = 128.0f;

    public LabColorSpace(float[] whitepoint, float[] blackpoint, float[] range) {
        this.value = 1847602;
        this.setCIEValues(whitepoint, blackpoint, range, null, null);
    }

    @Override
    public byte[] convertIndexToRGB(byte[] index) {
        this.isConverted = true;
        int size = index.length;
        for (int i = 0; i < size; i += 3) {
            float cl = (float)(index[i] & 0xFF) * 0.39215687f;
            float ca = (float)(index[i + 1] & 0xFF) - 128.0f;
            float cb = (float)(index[i + 2] & 0xFF) - 128.0f;
            this.convertToRGB(cl, ca, cb);
            index[i] = (byte)this.r;
            index[i + 1] = (byte)this.g;
            index[i + 2] = (byte)this.b;
        }
        return index;
    }

    @Override
    public BufferedImage JPEGToRGBImage(byte[] data, int w, int h, float[] decodeArray, int pX, int pY, boolean arrayInverted, PdfObject XObject2) {
        BufferedImage image;
        block3: {
            try {
                Raster ras = this.images.readRasterFromJPeg(data);
                ras = LabColorSpace.cleanupRaster(ras, pX, pY, 3);
                int width = ras.getWidth();
                int height = ras.getHeight();
                int imgSize = width * height;
                byte[] iData = ((DataBufferByte)ras.getDataBuffer()).getData();
                for (int i = 0; i < imgSize * 3; i += 3) {
                    float cl = (float)(iData[i] & 0xFF) * 0.39215687f;
                    float ca = (float)(iData[i + 1] & 0xFF) - 128.0f;
                    float cb = (float)(iData[i + 2] & 0xFF) - 128.0f;
                    this.convertToRGB(cl, ca, cb);
                    iData[i] = (byte)this.r;
                    iData[i + 1] = (byte)this.g;
                    iData[i + 2] = (byte)this.b;
                }
                image = new BufferedImage(width, height, 1);
                DataBufferByte db = new DataBufferByte(iData, iData.length);
                int[] bands = new int[]{0, 1, 2};
                WritableRaster raster = Raster.createInterleavedRaster(db, width, height, width * 3, 3, bands, null);
                image.setData(raster);
            }
            catch (Exception ee) {
                image = null;
                if (!LogWriter.isOutput()) break block3;
                LogWriter.writeLog("Couldn't read JPEG, not even raster: " + ee);
            }
        }
        return image;
    }

    @Override
    public BufferedImage dataToRGB(byte[] data, int width, int height) {
        BufferedImage image;
        block3: {
            int imgSize = width * height;
            try {
                for (int i = 0; i < imgSize * 3; i += 3) {
                    float cl = (float)(data[i] & 0xFF) * 0.39215687f;
                    float ca = (float)(data[i + 1] & 0xFF) - 128.0f;
                    float cb = (float)(data[i + 2] & 0xFF) - 128.0f;
                    this.convertToRGB(cl, ca, cb);
                    data[i] = (byte)this.r;
                    data[i + 1] = (byte)this.g;
                    data[i + 2] = (byte)this.b;
                }
                image = new BufferedImage(width, height, 1);
                Raster raster = ColorSpaceConvertor.createInterleavedRaster(data, width, height);
                image.setData(raster);
            }
            catch (Exception ee) {
                image = null;
                if (!LogWriter.isOutput()) break block3;
                LogWriter.writeLog("Couldn't read JPEG, not even raster: " + ee);
            }
        }
        return image;
    }

    private void convertToRGB(float l, float a, float bstar) {
        if (l < 0.0f) {
            l = 0.0f;
        } else if (l > 100.0f) {
            l = 100.0f;
        }
        if (a < this.R[0]) {
            a = this.R[0];
        } else if (a > this.R[1]) {
            a = this.R[1];
        }
        if (bstar < this.R[2]) {
            bstar = this.R[2];
        } else if (bstar > this.R[3]) {
            bstar = this.R[3];
        }
        if (this.lastL != l || this.lastA != a || this.lastBstar != bstar) {
            int indexL = (int)l;
            int indexA = (int)(a - this.R[0]);
            int indexB = (int)(bstar - this.R[2]);
            Integer key = (indexL << 16) + (indexA << 8) + indexB;
            Object value = this.cache.get(key);
            if (value != null) {
                int raw = (Integer)value;
                this.r = raw >> 16 & 0xFF;
                this.g = raw >> 8 & 0xFF;
                this.b = raw & 0xFF;
            } else {
                double val1 = ((double)l + 16.0) / 116.0;
                double[] vals = new double[]{val1 + (double)a / 500.0, val1, val1 - (double)bstar / 200.0};
                float[] out = new float[3];
                for (int j = 0; j < 3; ++j) {
                    out[j] = vals[j] >= 0.2068965584039688 ? (float)((double)this.W[j] * vals[j] * vals[j] * vals[j]) : (float)((double)(this.W[j] * 0.12841855f) * (vals[j] - 0.13793103396892548));
                    if (!(out[j] < 0.0f)) continue;
                    out[j] = 0.0f;
                }
                out = this.cs.toRGB(out);
                this.r = (int)(out[0] * 255.0f);
                this.g = (int)(out[1] * 255.0f);
                this.b = (int)(out[2] * 255.0f);
                if (this.r < 0) {
                    this.r = 0;
                }
                if (this.g < 0) {
                    this.g = 0;
                }
                if (this.b < 0) {
                    this.b = 0;
                }
                if (this.r > 255) {
                    this.r = 255;
                }
                if (this.g > 255) {
                    this.g = 255;
                }
                if (this.b > 255) {
                    this.b = 255;
                }
                int raw = (this.r << 16) + (this.g << 8) + this.b;
                this.cache.put(key, raw);
            }
            this.lastL = l;
            this.lastA = a;
            this.lastBstar = bstar;
        }
    }

    @Override
    public final void setColor(String[] number_values, int items) {
        float[] colValues = new float[items];
        for (int ii = 0; ii < items; ++ii) {
            colValues[ii] = Float.parseFloat(number_values[ii]);
        }
        this.setColor(colValues, items);
    }

    @Override
    public final void setColor(float[] operand, int length) {
        float l = operand[0];
        float a = operand[1];
        float Bstar = operand[2];
        this.convertToRGB(l, a, Bstar);
        this.currentColor = new PdfColor(this.r, this.g, this.b);
    }
}

