/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.handlers;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.jpedal.external.ImageHandler;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.raw.PdfObject;

public class ExampleImageHandler
implements ImageHandler {
    @Override
    public boolean alwaysIgnoreGenericHandler() {
        return true;
    }

    @Override
    public boolean imageHasBeenScaled() {
        return true;
    }

    @Override
    public boolean drawImageOnscreen(BufferedImage image, int optionsApplied, AffineTransform upside_down, String currentImageFile, Graphics2D g2, boolean renderDirect, ObjectStore objectStore, boolean isPrinting) {
        return false;
    }

    @Override
    public BufferedImage processImageData(GraphicsState gs, PdfObject XObject2) {
        int finalWidth = (int)gs.CTM[0][0];
        int finalHeight = (int)gs.CTM[1][1];
        if (finalWidth < 0) {
            finalWidth = -finalWidth;
        }
        if (finalHeight < 0) {
            finalHeight = -finalHeight;
        }
        BufferedImage img = new BufferedImage(finalWidth, finalHeight, 2);
        Graphics2D g2 = (Graphics2D)img.getGraphics();
        AffineTransform aff = new AffineTransform();
        aff.translate(0.0, -finalHeight);
        aff.scale(1.0, -1.0);
        g2.setTransform(aff);
        String message = "Image removed";
        int fontSize = finalWidth / message.length();
        Font font = new Font("serif", 0, fontSize);
        Rectangle2D messageBounds = font.getStringBounds(message, 0, message.length(), g2.getFontRenderContext());
        g2.setFont(font);
        g2.drawString(message, (int)(((double)finalWidth - messageBounds.getWidth()) / 2.0), -finalHeight - finalHeight / 2);
        return img;
    }
}

