/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.images;

import com.sun.imageio.plugins.jpeg.JPEGImageWriter;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.ImageEncoder;
import com.sun.media.jai.codec.TIFFEncodeParam;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import javax.media.jai.JAI;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.viewer.Commands;
import org.jpedal.exception.PdfException;
import org.jpedal.fonts.FontMappings;
import org.jpedal.io.JAIHelper;
import org.jpedal.objects.PdfFileInformation;
import org.jpedal.utils.LogWriter;
import org.w3c.dom.Element;

public class ConvertPagesToImages {
    boolean isTransparent = false;
    private String user_dir = System.getProperty("user.dir");
    private float pageScaling = 1.33f;
    public static boolean outputMessages = false;
    String output_dir = null;
    String separator = System.getProperty("file.separator");
    PdfDecoder decode_pdf = null;
    private String format = "png";
    private String[] ocr = new String[]{"TeleForm"};
    private boolean useHiresImage = false;
    private String test_file = "/mnt/shared/sample_pdfs/general/World Factbook.pdf";
    public static boolean isTest = false;
    public static boolean orderReversed = false;
    private int scaling = 100;
    private String password = null;
    private float JPEGcompression = -1.0f;

    public ConvertPagesToImages(String[] args) {
        String file_name = this.setParams(args);
        File pdf_file = new File(file_name);
        if (!pdf_file.exists()) {
            System.out.println("File " + pdf_file + " not found");
            System.out.println("May need full path");
            return;
        }
        this.extraction(file_name, this.output_dir);
    }

    private void extraction(String file_name, String output_dir) {
        String hiresFlag = System.getProperty("org.jpedal.hires");
        if (Commands.hires || hiresFlag != null) {
            this.useHiresImage = true;
        }
        this.output_dir = output_dir;
        if (!this.user_dir.endsWith(this.separator)) {
            this.user_dir = this.user_dir + this.separator;
        }
        if (file_name.toLowerCase().endsWith(".pdf")) {
            if (!isTest && output_dir == null) {
                output_dir = this.user_dir + "thumbnails" + this.separator;
            }
            this.decodeFile(file_name, output_dir);
        } else {
            String[] files = null;
            if (!file_name.endsWith(this.separator)) {
                file_name = file_name + this.separator;
            }
            try {
                File inputFiles = new File(file_name);
                if (!inputFiles.isDirectory()) {
                    System.err.println(file_name + " is not a directory. Exiting program");
                } else {
                    files = inputFiles.list();
                }
            }
            catch (Exception ee) {
                LogWriter.writeLog("Exception trying to access file " + ee.getMessage());
            }
            if (files != null) {
                for (String file : files) {
                    if (!file.toLowerCase().endsWith(".pdf")) continue;
                    if (outputMessages) {
                        System.out.println(file_name + file);
                    }
                    this.decodeFile(file_name + file, output_dir);
                }
            }
        }
        if (outputMessages) {
            System.out.println("Thumbnails created");
        }
    }

    private void decodeFile(String file_name, String output_dir) {
        String name = "demo";
        int pointer = file_name.lastIndexOf(this.separator);
        if (pointer == -1) {
            pointer = file_name.lastIndexOf(47);
        }
        if (pointer != -1) {
            name = file_name.substring(pointer + 1, file_name.length() - 4);
        } else if (!isTest && file_name.toLowerCase().endsWith(".pdf")) {
            name = file_name.substring(0, file_name.length() - 4);
        }
        if (output_dir == null) {
            output_dir = this.user_dir + "thumbnails" + this.separator;
        }
        try {
            this.decode_pdf = new PdfDecoder(true);
            if (!isTest) {
                FontMappings.setFontReplacements();
            }
            if (isTest) {
                this.pageScaling = 1.0f;
            }
            this.decode_pdf.setExtractionMode(0, this.pageScaling);
            if (outputMessages) {
                System.out.println("Opening file :" + file_name);
            }
            if (this.password != null) {
                this.decode_pdf.openPdfFile(file_name, this.password);
            } else {
                this.decode_pdf.openPdfFile(file_name);
            }
        }
        catch (Exception e) {
            System.err.println("8.Exception " + e + " in pdf code in " + file_name);
        }
        if (this.decode_pdf.isEncrypted() && !this.decode_pdf.isFileViewable()) {
            if (!isTest) {
                throw new RuntimeException("Wrong password password used=>" + this.password + '<');
            }
        } else {
            if (this.decode_pdf.isEncrypted() && !this.decode_pdf.isPasswordSupplied() && !this.decode_pdf.isExtractionAllowed()) {
                throw new RuntimeException("Extraction not allowed");
            }
            String separation = System.getProperty("org.jpedal.separation");
            if (separation != null) {
                Object[] sepValues = new Object[]{7, "", Boolean.FALSE};
                if (separation.equals("all")) {
                    sepValues = new Object[]{2, "image_and_shapes", Boolean.FALSE, 18, "image_without_shapes", Boolean.FALSE, 1, "text_and_shapes", Boolean.TRUE, 7, "all", Boolean.FALSE, 17, "text_without_shapes", Boolean.TRUE};
                }
                int sepCount = sepValues.length;
                for (int seps = 0; seps < sepCount; seps += 3) {
                    this.decode_pdf.setRenderMode((Integer)sepValues[seps]);
                    this.extractPageAsImage(file_name, output_dir, name + '_' + sepValues[seps + 1], (Boolean)sepValues[seps + 2]);
                }
            } else {
                this.extractPageAsImage(file_name, output_dir, name, this.isTransparent);
            }
        }
        this.decode_pdf.closePdfFile();
    }

    private void extractPageAsImage(String file_name, String output_dir, String name, boolean isTransparent) {
        boolean compressTiffs;
        String multiPageFlag;
        File output_path = new File(output_dir);
        if (!output_path.exists()) {
            output_path.mkdirs();
        }
        boolean isSingleOutputFile = (multiPageFlag = System.getProperty("org.jpedal.multipage_tiff")) != null && multiPageFlag.toLowerCase().equals("true");
        String rawJPEGComp = System.getProperty("org.jpedal.compression_jpeg");
        if (rawJPEGComp != null) {
            try {
                this.JPEGcompression = Float.parseFloat(rawJPEGComp);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.JPEGcompression < 0.0f || this.JPEGcompression > 1.0f) {
                throw new RuntimeException("Invalid value for JPEG compression - must be between 0 and 1");
            }
        }
        String tiffFlag = System.getProperty("org.jpedal.compress_tiff");
        String jpgFlag = System.getProperty("org.jpedal.jpeg_dpi");
        boolean bl = compressTiffs = tiffFlag != null && tiffFlag.toLowerCase().equals("true");
        if (JAIHelper.isJAIused()) {
            JAIHelper.confirmJAIOnClasspath();
        }
        int start = 1;
        int end = this.decode_pdf.getPageCount();
        if (end > 10 && isTest) {
            end = 10;
        }
        if (outputMessages) {
            System.out.println("Thumbnails will be in  " + output_dir);
        }
        try {
            BufferedImage[] multiPages = new BufferedImage[1 + (end - start)];
            if (orderReversed) {
                for (int page = end; page >= start; --page) {
                    this.getPage(output_dir, name, isTransparent, isSingleOutputFile, rawJPEGComp, jpgFlag, compressTiffs, start, end, multiPages, page);
                }
            } else {
                for (int page = start; page < end + 1; ++page) {
                    this.getPage(output_dir, name, isTransparent, isSingleOutputFile, rawJPEGComp, jpgFlag, compressTiffs, start, end, multiPages, page);
                }
            }
        }
        catch (Exception e) {
            this.decode_pdf.closePdfFile();
            throw new RuntimeException("Exception " + e.getMessage() + " with thumbnails on File=" + file_name);
        }
    }

    private void getPage(String output_dir, String name, boolean isTransparent, boolean isSingleOutputFile, String rawJPEGComp, String jpgFlag, boolean compressTiffs, int start, int end, BufferedImage[] multiPages, int page) throws PdfException, IOException, FileNotFoundException {
        boolean isGrayOnly;
        BufferedImage image_to_save;
        if (outputMessages) {
            System.out.println("Page " + page);
        }
        String pageAsString = String.valueOf(page);
        String maxPageSize = String.valueOf(end);
        int padding = maxPageSize.length() - pageAsString.length();
        for (int ii = 0; ii < padding; ++ii) {
            pageAsString = '0' + pageAsString;
        }
        String image_name = isSingleOutputFile ? name : name + "_page_" + pageAsString;
        PdfFileInformation currentFileInformation = this.decode_pdf.getFileInformationData();
        String[] values = currentFileInformation.getFieldValues();
        String[] fields = PdfFileInformation.getFieldNames();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].equals("Creator")) continue;
            for (String anOcr : this.ocr) {
                if (!values[i].equals(anOcr)) continue;
                this.decode_pdf.setRenderMode(2);
            }
        }
        if (!isTransparent) {
            image_to_save = this.decode_pdf.getPageAsImage(page);
        } else {
            image_to_save = this.decode_pdf.getPageAsTransparentImage(page);
            if (image_to_save != null && this.format.toLowerCase().startsWith("jp")) {
                BufferedImage rawVersion = image_to_save;
                int w = rawVersion.getWidth();
                int h = rawVersion.getHeight();
                image_to_save = new BufferedImage(w, h, 1);
                Graphics2D g2 = image_to_save.createGraphics();
                g2.setPaint(Color.WHITE);
                g2.fillRect(0, 0, w, h);
                g2.drawImage((Image)rawVersion, 0, 0, null);
            }
        }
        Iterator colorspacesUsed = this.decode_pdf.getPageInfo(1);
        boolean bl = isGrayOnly = colorspacesUsed != null;
        while (colorspacesUsed != null && colorspacesUsed.hasNext()) {
            int nextID = (Integer)colorspacesUsed.next();
            if (nextID == 1568372915 || nextID == 391471749) continue;
            isGrayOnly = false;
        }
        if (isGrayOnly) {
            BufferedImage image_to_save2 = new BufferedImage(image_to_save.getWidth(), image_to_save.getHeight(), 10);
            image_to_save2.getGraphics().drawImage(image_to_save, 0, 0, null);
            image_to_save = image_to_save2;
        }
        if (isSingleOutputFile) {
            multiPages[page - start] = image_to_save;
        }
        if (image_to_save == null) {
            if (outputMessages && !isTest) {
                System.out.println("No image generated - are you using client mode?");
            }
        } else {
            String imageFormat;
            String maxDimensionAsString = System.getProperty("maxDimension");
            int maxDimension = -1;
            if (maxDimensionAsString != null) {
                maxDimension = Integer.parseInt(maxDimensionAsString);
            }
            if (this.scaling != 100 || maxDimension != -1) {
                Image scaledImage;
                int newWidth = image_to_save.getWidth() * this.scaling / 100;
                int newHeight = image_to_save.getHeight() * this.scaling / 100;
                if (maxDimension != -1 && (newWidth > maxDimension || newHeight > maxDimension)) {
                    if (newWidth > newHeight) {
                        newWidth = maxDimension;
                        scaledImage = image_to_save.getScaledInstance(newWidth, -1, 4);
                    } else {
                        newHeight = maxDimension;
                        scaledImage = image_to_save.getScaledInstance(-1, newHeight, 4);
                    }
                } else {
                    scaledImage = image_to_save.getScaledInstance(newWidth, -1, 4);
                }
                image_to_save = this.format.toLowerCase().startsWith("jp") ? new BufferedImage(scaledImage.getWidth(null), scaledImage.getHeight(null), 1) : new BufferedImage(scaledImage.getWidth(null), scaledImage.getHeight(null), 2);
                Graphics2D g2 = image_to_save.createGraphics();
                g2.drawImage(scaledImage, 0, 0, null);
            }
            if ((imageFormat = System.getProperty("org.jpedal.imageType")) != null) {
                if (ConvertPagesToImages.isNumber(imageFormat)) {
                    int iFormat = Integer.parseInt(imageFormat);
                    if (iFormat > -1 && iFormat < 14) {
                        BufferedImage tempImage = new BufferedImage(image_to_save.getWidth(), image_to_save.getHeight(), iFormat);
                        Graphics2D g = tempImage.createGraphics();
                        g.drawImage(image_to_save, null, null);
                        image_to_save = tempImage;
                    } else {
                        System.err.println("Image Type is not valid. Value should be a digit between 0 - 13 based on the BufferedImage TYPE variables.");
                    }
                } else {
                    System.err.println("Image Type provided is not an Integer. Value should be a digit between 0 - 13 based on the BufferedImage TYPE variables.");
                }
            }
            if (JAIHelper.isJAIused() && this.format.startsWith("tif")) {
                TIFFEncodeParam params = new TIFFEncodeParam();
                if (compressTiffs) {
                    params.setCompression(32773);
                }
                if (!isSingleOutputFile) {
                    BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(output_dir + pageAsString + image_name + ".tif"));
                    JAI.create((String)"encode", (RenderedImage)image_to_save, (Object)os, (Object)"TIFF", (Object)params);
                } else if (isSingleOutputFile && page == end) {
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(output_dir + image_name + ".tif"));
                    ImageEncoder encoder = ImageCodec.createImageEncoder((String)"TIFF", (OutputStream)out, (ImageEncodeParam)params);
                    ArrayList<BufferedImage> vector = new ArrayList<BufferedImage>();
                    vector.addAll(Arrays.asList(multiPages).subList(1, multiPages.length));
                    params.setExtraImages(vector.iterator());
                    encoder.encode((RenderedImage)multiPages[0]);
                    ((OutputStream)out).close();
                }
            } else if ((jpgFlag != null || rawJPEGComp != null) && this.format.startsWith("jp") && JAIHelper.isJAIused()) {
                ConvertPagesToImages.saveAsJPEG(jpgFlag, image_to_save, this.JPEGcompression, new BufferedOutputStream(new FileOutputStream(output_dir + pageAsString + image_name + '.' + this.format)));
            } else {
                this.decode_pdf.getObjectStore().saveStoredImage(output_dir + pageAsString + image_name, image_to_save, true, false, this.format);
            }
        }
        this.decode_pdf.flushObjectValues(true);
    }

    public static void main(String[] args) {
        boolean failed;
        System.out.println("Simple demo to extract images from a page");
        int count = args.length;
        boolean bl = failed = count > 4 || count == 0;
        if (failed) {
            if (count > 0) {
                System.out.println("too many arguments entered - run with no values to see defaults");
                String arguments = "";
                for (String arg : args) {
                    arguments = arguments + arg + '\n';
                }
                System.out.println("you entered:\n" + arguments + "as the arguments");
            }
            ConvertPagesToImages.showCommandLineValues();
        }
        new ConvertPagesToImages(args);
    }

    private String setParams(String[] args) {
        String file_name = this.test_file;
        int len = args.length;
        if (len == 0) {
            ConvertPagesToImages.showCommandLineValues();
        } else if (len == 1) {
            file_name = args[0];
        } else if (len < 6) {
            file_name = args[0];
            for (int j = 1; j < args.length; ++j) {
                String value = args[j];
                boolean isNumber = ConvertPagesToImages.isNumber(value);
                if (isNumber) {
                    try {
                        this.scaling = Integer.parseInt(value);
                        continue;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(value + " is not an integer");
                    }
                }
                String in = value.toLowerCase();
                if (in.equals("jpg") || in.equals("jpeg")) {
                    this.format = "jpg";
                    continue;
                }
                if (in.equals("tif") || in.equals("tiff")) {
                    this.format = "tif";
                    continue;
                }
                if (in.equals("png")) {
                    this.format = "png";
                    continue;
                }
                if (value.endsWith("/") || value.endsWith("\\")) {
                    this.output_dir = value;
                    continue;
                }
                this.password = value;
            }
        }
        return file_name;
    }

    static void showCommandLineValues() {
        System.out.println("Example can take 1-5 parameters");
        System.out.println("Value 1 is the file name or directory of PDF files to process");
        System.out.println("4 optional values of:-\nimage type (jpeg,tiff,png), \nscaling (100 = full size), \npassword for protected file (or null) can also be added ,\noutput path (must end with / or \\ character)");
        System.exit(0);
    }

    private static boolean isNumber(String value) {
        boolean isNumber = true;
        int charCount = value.length();
        for (int i = 0; i < charCount; ++i) {
            char c = value.charAt(i);
            if (!(c < '0' | c > '9')) continue;
            isNumber = false;
            i = charCount;
        }
        return isNumber;
    }

    public String getOutputDir() {
        return this.output_dir;
    }

    private static void saveAsJPEG(String jpgFlag, BufferedImage image_to_save, float JPEGcompression, BufferedOutputStream fos) throws IOException {
        JPEGImageWriter imageWriter = (JPEGImageWriter)ImageIO.getImageWritersBySuffix("jpeg").next();
        ImageOutputStream ios = ImageIO.createImageOutputStream(fos);
        imageWriter.setOutput(ios);
        IIOMetadata imageMetaData = imageWriter.getDefaultImageMetadata(new ImageTypeSpecifier(image_to_save), null);
        if (jpgFlag != null) {
            int dpi = 96;
            try {
                dpi = Integer.parseInt(jpgFlag);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Element tree = (Element)imageMetaData.getAsTree("javax_imageio_jpeg_image_1.0");
            Element jfif = (Element)tree.getElementsByTagName("app0JFIF").item(0);
            jfif.setAttribute("Xdensity", Integer.toString(dpi));
            jfif.setAttribute("Ydensity", Integer.toString(dpi));
        }
        if (JPEGcompression >= 0.0f && JPEGcompression <= 1.0f) {
            JPEGImageWriteParam jpegParams = (JPEGImageWriteParam)imageWriter.getDefaultWriteParam();
            jpegParams.setCompressionMode(2);
            jpegParams.setCompressionQuality(JPEGcompression);
        }
        imageWriter.write(imageMetaData, new IIOImage(image_to_save, null, null), null);
        ios.close();
        imageWriter.dispose();
    }
}

