/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.popups;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.print.attribute.standard.PageRanges;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import org.jpedal.examples.viewer.Viewer;
import org.jpedal.examples.viewer.gui.popups.Save;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class RotatePDFPages
extends Save {
    private static final long serialVersionUID = -5503601641263122454L;
    JLabel OutputLabel = new JLabel();
    ButtonGroup buttonGroup1 = new ButtonGroup();
    ButtonGroup buttonGroup2 = new ButtonGroup();
    JToggleButton jToggleButton3 = new JToggleButton();
    JToggleButton jToggleButton2 = new JToggleButton();
    JRadioButton printAll = new JRadioButton();
    JRadioButton printCurrent = new JRadioButton();
    JRadioButton printPages = new JRadioButton();
    JTextField pagesBox = new JTextField();
    final String[] rotationItems = new String[]{Messages.getMessage("PdfViewerComboBox.Clockwise90"), Messages.getMessage("PdfViewerComboBox.CounterClockwise90"), Messages.getMessage("PdfViewerComboBox.180Degrees")};
    JLabel direction = new JLabel(Messages.getMessage("PdfViewerMessage.Direction"));
    JComboBox directionBox = new JComboBox<String>(this.rotationItems);

    public RotatePDFPages(String root_dir, int end_page, int currentPage) {
        super(root_dir, end_page, currentPage);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int[] getRotatedPages() {
        int[] pagesToExport = null;
        if (this.printAll.isSelected()) {
            pagesToExport = new int[this.end_page];
            for (int i = 0; i < this.end_page; ++i) {
                pagesToExport[i] = i + 1;
            }
            return pagesToExport;
        } else if (this.printCurrent.isSelected()) {
            pagesToExport = new int[]{this.currentPage};
            return pagesToExport;
        } else {
            if (!this.printPages.isSelected()) return pagesToExport;
            try {
                PageRanges pages = new PageRanges(this.pagesBox.getText());
                int count = 0;
                int i = -1;
                while ((i = pages.next(i)) != -1) {
                    ++count;
                }
                pagesToExport = new int[count];
                count = 0;
                i = -1;
                while ((i = pages.next(i)) != -1) {
                    if (i > this.end_page) {
                        if (!Viewer.showMessages) return null;
                        JOptionPane.showMessageDialog(this, Messages.getMessage("PdfViewerText.Page") + ' ' + i + ' ' + Messages.getMessage("PdfViewerError.OutOfBounds") + ' ' + Messages.getMessage("PdfViewerText.PageCount") + ' ' + this.end_page);
                        return null;
                    }
                    pagesToExport[count] = i;
                    ++count;
                }
                return pagesToExport;
            }
            catch (IllegalArgumentException e) {
                LogWriter.writeLog("Exception " + e + " in exporting pdfs");
                if (!Viewer.showMessages) return pagesToExport;
                JOptionPane.showMessageDialog(this, Messages.getMessage("PdfViewerError.InvalidSyntax"));
            }
        }
        return pagesToExport;
    }

    public int getDirection() {
        return this.directionBox.getSelectedIndex();
    }

    private void jbInit() throws Exception {
        this.direction.setFont(new Font("Dialog", 1, 14));
        this.direction.setDisplayedMnemonic('0');
        this.direction.setBounds(new Rectangle(13, 13, 220, 26));
        this.directionBox.setBounds(new Rectangle(23, 40, 300, 23));
        this.pageRangeLabel.setText(Messages.getMessage("PdfViewerPageRange.text"));
        this.pageRangeLabel.setBounds(new Rectangle(13, 71, 199, 26));
        this.printAll.setText(Messages.getMessage("PdfViewerRadioButton.All"));
        this.printAll.setBounds(new Rectangle(23, 100, 75, 22));
        this.printCurrent.setText(Messages.getMessage("PdfViewerRadioButton.CurrentPage"));
        this.printCurrent.setBounds(new Rectangle(23, 120, 100, 22));
        this.printCurrent.setSelected(true);
        this.printPages.setText(Messages.getMessage("PdfViewerRadioButton.Pages"));
        this.printPages.setBounds(new Rectangle(23, 142, 70, 22));
        this.pagesBox.setBounds(new Rectangle(95, 142, 200, 22));
        this.pagesBox.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent arg0) {
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
                if (RotatePDFPages.this.pagesBox.getText().length() == 0) {
                    RotatePDFPages.this.printCurrent.setSelected(true);
                } else {
                    RotatePDFPages.this.printPages.setSelected(true);
                }
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
            }
        });
        JTextArea pagesInfo = new JTextArea(Messages.getMessage("PdfViewerMessage.PageNumberOrRange") + '\n' + Messages.getMessage("PdfViewerMessage.PageRangeExample"));
        pagesInfo.setBounds(new Rectangle(23, 185, 400, 40));
        pagesInfo.setOpaque(false);
        this.optionsForFilesLabel.setBounds(new Rectangle(13, 220, 199, 26));
        this.add((Component)this.printAll, null);
        this.add((Component)this.printCurrent, null);
        this.add((Component)this.printPages, null);
        this.add((Component)this.pagesBox, null);
        this.add((Component)pagesInfo, null);
        this.add((Component)this.directionBox, null);
        this.add((Component)this.direction, null);
        this.add((Component)this.changeButton, null);
        this.add((Component)this.pageRangeLabel, null);
        this.add((Component)this.jToggleButton2, null);
        this.add((Component)this.jToggleButton3, null);
        this.buttonGroup1.add(this.printAll);
        this.buttonGroup1.add(this.printCurrent);
        this.buttonGroup1.add(this.printPages);
    }

    @Override
    public final Dimension getPreferredSize() {
        return new Dimension(400, 250);
    }
}

