/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.swing;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import org.jpedal.examples.viewer.gui.generic.GUIButton;

public class SwingButton
extends JButton
implements GUIButton {
    private static final long serialVersionUID = -7448813287258699275L;
    private int ID;

    public SwingButton() {
    }

    public SwingButton(String string) {
        super(string);
    }

    @Override
    public void init(URL path, int ID, String toolTip) {
        this.ID = ID;
        this.setToolTipText(toolTip);
        this.setBorderPainted(false);
        if (path != null) {
            ImageIcon icon = new ImageIcon(path);
            this.setIcon(icon);
            SwingButton.createPressedLook(this, icon);
        }
    }

    private static void createPressedLook(AbstractButton button, ImageIcon icon) {
        BufferedImage image = new BufferedImage(icon.getIconWidth() + 2, icon.getIconHeight() + 2, 2);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.drawImage(icon.getImage(), 1, 1, null);
        g.dispose();
        ImageIcon iconPressed = new ImageIcon(image);
        button.setPressedIcon(iconPressed);
    }

    @Override
    public void setIcon(ImageIcon icon) {
        super.setIcon(icon);
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled();
    }

    @Override
    public int getID() {
        return this.ID;
    }

    @Override
    public void setName(String s) {
        super.setName(s);
    }
}

