/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.utils;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.media.jai.JAI;
import javax.swing.ProgressMonitor;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.gui.popups.SaveImage;
import org.jpedal.examples.viewer.gui.popups.SaveText;
import org.jpedal.exception.PdfException;
import org.jpedal.exception.PdfSecurityException;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.gui.GUIFactory;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.JAIHelper;
import org.jpedal.objects.PdfImageData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.jpedal.utils.Strip;
import org.jpedal.utils.SwingWorker;

public class Exporter {
    public static final int RECTANGLE = 1;
    public static final int WORDLIST = 2;
    public static final int TABLE = 3;
    private final String separator = System.getProperty("file.separator");
    private String fileName = "";
    private GUIFactory currentGUI;
    private PdfDecoder dPDF;
    private String selectedFile;

    public Exporter(SwingGUI currentGUI, String selectedFile, PdfDecoder decode_pdf) {
        int index;
        String fileName = new File(selectedFile).getName();
        if (fileName.lastIndexOf(46) != -1) {
            fileName = fileName.substring(0, fileName.lastIndexOf(46));
        }
        StringBuilder fileNameBuffer = new StringBuilder(fileName);
        while ((index = fileNameBuffer.toString().indexOf("%20")) != -1) {
            fileNameBuffer.replace(index, index + 3, " ");
        }
        this.fileName = fileNameBuffer.toString();
        this.currentGUI = currentGUI;
        this.selectedFile = selectedFile;
        this.dPDF = decode_pdf;
    }

    private static void saveImage(BufferedImage image_to_save, String fileName, String prefix) {
        if (JAIHelper.isJAIused()) {
            JAIHelper.confirmJAIOnClasspath();
        }
        if (prefix.contains("tif") && JAIHelper.isJAIused()) {
            try {
                FileOutputStream os = new FileOutputStream(fileName);
                JAI.create((String)"encode", (RenderedImage)image_to_save, (Object)os, (Object)"TIFF", null);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            try {
                ImageIO.write((RenderedImage)image_to_save, prefix, new File(fileName));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void decodeHires(int start, int end, String imageType, String output_dir) {
        PdfDecoder decode_pdf = null;
        String target = "";
        try {
            decode_pdf = new PdfDecoder(false);
            decode_pdf.setExtractionMode(36, 1.0f);
            decode_pdf.openPdfFile(this.selectedFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (decode_pdf.isEncrypted() && !decode_pdf.isPasswordSupplied() && !decode_pdf.isExtractionAllowed()) {
            return;
        }
        ProgressMonitor status = new ProgressMonitor(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerMessage.ExtractImages"), "", start, end);
        try {
            int count = 0;
            boolean yesToAll = false;
            for (int page = start; page < end + 1; ++page) {
                File targetExists;
                if (status.isCanceled()) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerError.UserStoppedExport") + count + ' ' + Messages.getMessage("PdfViewerError.ReportNumberOfImagesExported"));
                    return;
                }
                decode_pdf.decodePage(page);
                PdfImageData pdf_images = decode_pdf.getPdfImageData();
                int image_count = pdf_images.getImageCount();
                if (image_count > 0 && !(targetExists = new File(target = output_dir + page + this.separator)).exists()) {
                    targetExists.mkdir();
                }
                for (int i = 0; i < image_count; ++i) {
                    String image_name = pdf_images.getImageName(i);
                    float x1 = pdf_images.getImageXCoord(i);
                    float y1 = pdf_images.getImageYCoord(i);
                    float w = pdf_images.getImageWidth(i);
                    float h = pdf_images.getImageHeight(i);
                    try {
                        BufferedImage image_to_save = decode_pdf.getObjectStore().loadStoredImage("CLIP_" + image_name);
                        if (image_to_save != null) {
                            int n;
                            File fileToSave;
                            if (imageType.toLowerCase().startsWith("jp")) {
                                image_to_save = ColorSpaceConvertor.convertToRGB(image_to_save);
                            }
                            if ((fileToSave = new File(target + image_name + '.' + imageType)).exists() && !yesToAll && (n = this.currentGUI.showOverwriteDialog(fileToSave.getAbsolutePath(), true)) != 0) {
                                if (n == 1) {
                                    yesToAll = true;
                                } else {
                                    if (n == 2) {
                                        status.setProgress(page);
                                        continue;
                                    }
                                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerError.UserStoppedExport") + count + ' ' + Messages.getMessage("PdfViewerError.ReportNumberOfImagesExported"));
                                    status.close();
                                    return;
                                }
                            }
                            Exporter.saveImage(image_to_save, target + image_name + '.' + imageType, imageType);
                            ++count;
                        }
                        OutputStreamWriter output_stream = new OutputStreamWriter((OutputStream)new FileOutputStream(target + image_name + ".xml"), "UTF-8");
                        output_stream.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                        output_stream.write("<!-- Pixel Location of image x1,y1,x2,y2\n");
                        output_stream.write("(x1,y1 is top left corner)\n");
                        output_stream.write("(origin is bottom left corner)  -->\n");
                        output_stream.write("\n\n<META>\n");
                        output_stream.write("<PAGELOCATION x1=\"" + x1 + "\" y1=\"" + (y1 + h) + "\" x2=\"" + (x1 + w) + "\" y2=\"" + y1 + "\" />\n");
                        output_stream.write("<FILE>" + this.fileName + "</FILE>\n");
                        output_stream.write("</META>\n");
                        output_stream.close();
                        continue;
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                        LogWriter.writeLog("Exception " + ee + " in extracting images");
                    }
                }
                decode_pdf.flushObjectValues(true);
                status.setProgress(page + 1);
            }
            status.close();
            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.ImagesSavedTo") + ' ' + output_dir);
        }
        catch (Exception e) {
            decode_pdf.closePdfFile();
            LogWriter.writeLog("Exception " + e.getMessage());
        }
        decode_pdf.closePdfFile();
    }

    public void extractImagesOnPages(SaveImage current_selection) {
        final int startPage = current_selection.getStartPage();
        final int endPage = current_selection.getEndPage();
        if (startPage < 1 || endPage < 1) {
            return;
        }
        final int type = current_selection.getImageType();
        final String format = current_selection.getPrefix();
        final String output_dir = current_selection.getRootDir() + this.separator + this.fileName + this.separator + "images" + this.separator;
        File testDirExists = new File(output_dir);
        if (!testDirExists.exists()) {
            testDirExists.mkdirs();
        }
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                switch (type) {
                    case 32: {
                        Exporter.this.decodeHires(startPage, endPage, format, output_dir);
                        break;
                    }
                    case 2: {
                        Exporter.this.decodeImages(startPage, endPage, format, output_dir, false);
                        break;
                    }
                    case 4: {
                        Exporter.this.decodeImages(startPage, endPage, format, output_dir, true);
                        break;
                    }
                    default: {
                        System.out.println("Unknown setting");
                    }
                }
                return null;
            }
        };
        worker.start();
    }

    private void decodeImages(int start, int end, String prefix, String output_dir, boolean downsampled) {
        PdfDecoder decode_pdf = null;
        try {
            decode_pdf = new PdfDecoder(false);
            decode_pdf.setExtractionMode(6, 1.0f);
            decode_pdf.openPdfFile(this.selectedFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (decode_pdf.isEncrypted() && !decode_pdf.isPasswordSupplied() && !decode_pdf.isExtractionAllowed()) {
            return;
        }
        ProgressMonitor status = new ProgressMonitor(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerMessage.ExtractImages"), "", start, end);
        try {
            int count = 0;
            boolean yesToAll = false;
            for (int page = start; page < end + 1; ++page) {
                if (status.isCanceled()) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerError.UserStoppedExport") + count + Messages.getMessage("PdfViewerError.ReportNumberOfImagesExported"));
                    return;
                }
                decode_pdf.decodePage(page);
                PdfImageData pdf_images = decode_pdf.getPdfImageData();
                int image_count = pdf_images.getImageCount();
                String target = output_dir + this.separator;
                target = downsampled ? target + "downsampled" + this.separator + page + this.separator : target + "normal" + this.separator + page + this.separator;
                if (image_count > 0) {
                    File page_path = new File(target);
                    if (!page_path.exists()) {
                        page_path.mkdirs();
                    }
                    if (!(page_path = new File(target)).exists()) {
                        page_path.mkdirs();
                    }
                }
                for (int i = 0; i < image_count; ++i) {
                    String image_name = pdf_images.getImageName(i);
                    try {
                        int n;
                        File fileToSave;
                        BufferedImage image_to_save;
                        if (downsampled) {
                            image_to_save = decode_pdf.getObjectStore().loadStoredImage(image_name);
                            if (prefix.toLowerCase().startsWith("jp")) {
                                image_to_save = ColorSpaceConvertor.convertToRGB(image_to_save);
                            }
                        } else {
                            image_to_save = decode_pdf.getObjectStore().loadStoredImage(image_name);
                            if (prefix.toLowerCase().startsWith("jp")) {
                                image_to_save = ColorSpaceConvertor.convertToRGB(image_to_save);
                            }
                        }
                        if ((fileToSave = new File(target + image_name + '.' + prefix)).exists() && !yesToAll && (n = this.currentGUI.showOverwriteDialog(fileToSave.getAbsolutePath(), true)) != 0) {
                            if (n == 1) {
                                yesToAll = true;
                            } else {
                                if (n == 2) {
                                    status.setProgress(page);
                                    continue;
                                }
                                this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerError.UserStoppedExport") + count + ' ' + Messages.getMessage("PdfViewerError.ReportNumberOfImagesExported"));
                                status.close();
                                return;
                            }
                        }
                        Exporter.saveImage(image_to_save, target + image_name + '.' + prefix, prefix);
                        ++count;
                        continue;
                    }
                    catch (Exception ee) {
                        System.err.println("Exception " + ee + " in extracting images");
                    }
                }
                decode_pdf.flushObjectValues(true);
                status.setProgress(page + 1);
            }
            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.ImagesSavedTo") + ' ' + output_dir);
            status.close();
        }
        catch (Exception e) {
            decode_pdf.closePdfFile();
            LogWriter.writeLog("Exception " + e.getMessage());
        }
        decode_pdf.closePdfFile();
    }

    public void extractTextOnPages(SaveText current_selection) {
        final int startPage = current_selection.getStartPage();
        final int endPage = current_selection.getEndPage();
        if (startPage < 1 || endPage < 1) {
            return;
        }
        final int type = current_selection.getTextType();
        final boolean useXMLExtraction = current_selection.isXMLExtaction();
        final String output_dir = current_selection.getRootDir() + this.separator + this.fileName + this.separator + "text" + this.separator;
        File testDirExists = new File(output_dir);
        if (!testDirExists.exists()) {
            testDirExists.mkdirs();
        }
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                switch (type) {
                    case 1: {
                        Exporter.this.decodeTextRectangle(startPage, endPage, output_dir, useXMLExtraction);
                        break;
                    }
                    case 2: {
                        Exporter.this.decodeTextWordlist(startPage, endPage, output_dir, useXMLExtraction);
                        break;
                    }
                    case 3: {
                        Exporter.this.decodeTextTable(startPage, endPage, output_dir, useXMLExtraction);
                        break;
                    }
                    default: {
                        System.out.println("Unknown setting");
                    }
                }
                return null;
            }
        };
        worker.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeTextTable(int startPage, int endPage, String output_dir, boolean useXMLExtraction) {
        PdfDecoder decode_pdf = null;
        try {
            decode_pdf = new PdfDecoder(false);
            decode_pdf.setExtractionMode(1);
            PdfDecoder.init(true);
            decode_pdf.openPdfFile(this.selectedFile);
        }
        catch (Exception e) {
            System.err.println("Exception " + e + " in pdf code");
        }
        if (decode_pdf.isEncrypted() && !decode_pdf.isPasswordSupplied() && !decode_pdf.isExtractionAllowed()) {
            System.out.println("Encrypted settings");
            System.out.println("Please look at Viewer for code sample to handle such files");
        } else {
            ProgressMonitor status = new ProgressMonitor(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerMessage.ExtractText"), "", startPage, endPage);
            try {
                int count = 0;
                boolean yesToAll = false;
                for (int page = startPage; page < endPage + 1; ++page) {
                    if (status.isCanceled()) {
                        this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerError.UserStoppedExport") + count + ' ' + Messages.getMessage("PdfViewerError.ReportNumberOfPagesExported"));
                        return;
                    }
                    decode_pdf.decodePage(page);
                    PdfGroupingAlgorithms currentGrouping = decode_pdf.getGroupingObject();
                    PdfPageData currentPageData = decode_pdf.getPdfPageData();
                    int x1 = currentPageData.getMediaBoxX(page);
                    int x2 = currentPageData.getMediaBoxWidth(page) + x1;
                    int y2 = currentPageData.getMediaBoxY(page);
                    int y1 = currentPageData.getMediaBoxHeight(page) + y2;
                    String ending = "_text.csv";
                    if (useXMLExtraction) {
                        ending = "_xml.txt";
                    }
                    String tableText = null;
                    try {
                        Map tableContent = currentGrouping.extractTextAsTable(x1, y1, x2, y2, page, !useXMLExtraction, false, false, false, 0);
                        tableText = (String)tableContent.get("content");
                    }
                    catch (PdfException e) {
                        decode_pdf.closePdfFile();
                        System.err.println("Exception " + e.getMessage() + " with table extraction");
                    }
                    catch (Error e) {
                        e.printStackTrace();
                    }
                    if (tableText == null) {
                        System.out.println("No text found");
                    } else {
                        File fileToSave;
                        String target = output_dir + this.separator + "table" + this.separator;
                        File output_path = new File(target);
                        if (!output_path.exists()) {
                            output_path.mkdirs();
                        }
                        if ((fileToSave = new File(target + this.fileName + '_' + page + ending)).exists() && !yesToAll) {
                            int n;
                            if (endPage - startPage > 1) {
                                n = this.currentGUI.showOverwriteDialog(fileToSave.getAbsolutePath(), true);
                                if (n != 0) {
                                    if (n == 1) {
                                        yesToAll = true;
                                    } else {
                                        if (n != 2) {
                                            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerError.UserStoppedExport") + count + ' ' + Messages.getMessage("PdfViewerError.ReportNumberOfPagesExported"));
                                            status.close();
                                            return;
                                        }
                                        status.setProgress(page);
                                        continue;
                                    }
                                }
                            } else {
                                n = this.currentGUI.showOverwriteDialog(fileToSave.getAbsolutePath(), false);
                                if (n != 0) {
                                    return;
                                }
                            }
                        }
                        OutputStreamWriter output_stream = new OutputStreamWriter((OutputStream)new FileOutputStream(target + this.fileName + '_' + page + ending), "UTF-8");
                        if (useXMLExtraction) {
                            output_stream.write("<xml><BODY>\n\n");
                        }
                        output_stream.write(tableText);
                        if (useXMLExtraction) {
                            output_stream.write("\n</body></xml>");
                        }
                        output_stream.close();
                    }
                    ++count;
                    status.setProgress(page + 1);
                    decode_pdf.flushObjectValues(false);
                }
                status.close();
                this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.TextSavedTo") + ' ' + output_dir);
            }
            catch (Exception e) {
                decode_pdf.closePdfFile();
                System.err.println("Exception " + e.getMessage());
                e.printStackTrace();
            }
            catch (Error e) {
                System.out.println("h34343");
                e.printStackTrace();
            }
            decode_pdf.flushObjectValues(true);
        }
        decode_pdf.closePdfFile();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeTextWordlist(int startPage, int endPage, String output_dir, boolean useXMLExtraction) {
        PdfDecoder decode_pdf = null;
        try {
            decode_pdf = new PdfDecoder(false);
            decode_pdf.setExtractionMode(1);
            PdfDecoder.init(true);
            PdfGroupingAlgorithms.useUnrotatedCoords = false;
            decode_pdf.openPdfFile(this.selectedFile);
        }
        catch (PdfSecurityException e) {
            System.err.println("Exception " + e + " in pdf code for wordlist" + this.selectedFile);
        }
        catch (PdfException e) {
            System.err.println("Exception " + e + " in pdf code for wordlist" + this.selectedFile);
        }
        catch (Exception e) {
            System.err.println("Exception " + e + " in pdf code for wordlist" + this.selectedFile);
            e.printStackTrace();
        }
        if (decode_pdf.isEncrypted() && !decode_pdf.isPasswordSupplied() && !decode_pdf.isExtractionAllowed()) {
            System.out.println("Encrypted settings");
            System.out.println("Please look at Viewer for code sample to handle such files");
        } else {
            int start = startPage;
            int end = endPage;
            int wordsExtracted = 0;
            ProgressMonitor status = new ProgressMonitor(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerMessage.ExtractText"), "", startPage, endPage);
            try {
                int count = 0;
                boolean yesToAll = false;
                for (int page = start; page < end + 1; ++page) {
                    if (status.isCanceled()) {
                        this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerError.UserStoppedExport") + count + ' ' + Messages.getMessage("PdfViewerError.ReportNumberOfPagesExported"));
                        return;
                    }
                    decode_pdf.decodePage(page);
                    PdfGroupingAlgorithms currentGrouping = decode_pdf.getGroupingObject();
                    PdfPageData currentPageData = decode_pdf.getPdfPageData();
                    int x1 = currentPageData.getMediaBoxX(page);
                    int x2 = currentPageData.getMediaBoxWidth(page) + x1;
                    int y2 = currentPageData.getMediaBoxX(page);
                    int y1 = currentPageData.getMediaBoxHeight(page) - y2;
                    List words = null;
                    try {
                        words = currentGrouping.extractTextAsWordlist(x1, y1, x2, y2, page, true, "&:=()!;.,\\/\"\"''");
                    }
                    catch (PdfException e) {
                        decode_pdf.closePdfFile();
                        System.err.println("Exception= " + e + " in " + this.selectedFile);
                        e.printStackTrace();
                    }
                    catch (Error e) {
                        e.printStackTrace();
                    }
                    if (words == null) {
                        System.out.println("No text found");
                    } else {
                        String target = output_dir + this.separator + "wordlist" + this.separator;
                        File output_path = new File(target);
                        if (!output_path.exists()) {
                            output_path.mkdirs();
                        }
                        String prefix = "_text.txt";
                        String encoding = System.getProperty("file.encoding");
                        if (useXMLExtraction) {
                            prefix = "_xml.txt";
                            encoding = "UTF-8";
                        }
                        int wordCount = words.size() / 5;
                        wordsExtracted += wordCount;
                        File fileToSave = new File(target + this.fileName + '_' + page + prefix);
                        if (fileToSave.exists() && !yesToAll) {
                            int n;
                            if (endPage - startPage > 1) {
                                n = this.currentGUI.showOverwriteDialog(fileToSave.getAbsolutePath(), true);
                                if (n != 0) {
                                    if (n == 1) {
                                        yesToAll = true;
                                    } else {
                                        if (n != 2) {
                                            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerError.UserStoppedExport") + count + ' ' + Messages.getMessage("PdfViewerError.ReportNumberOfPagesExported"));
                                            status.close();
                                            return;
                                        }
                                        status.setProgress(page);
                                        continue;
                                    }
                                }
                            } else {
                                n = this.currentGUI.showOverwriteDialog(fileToSave.getAbsolutePath(), false);
                                if (n != 0) {
                                    return;
                                }
                            }
                        }
                        OutputStreamWriter output_stream = new OutputStreamWriter((OutputStream)new FileOutputStream(target + this.fileName + '_' + page + prefix), encoding);
                        Iterator wordIterator = words.iterator();
                        while (wordIterator.hasNext()) {
                            String currentWord = (String)wordIterator.next();
                            if (!useXMLExtraction) {
                                currentWord = Strip.convertToText(currentWord, true);
                            }
                            int wx1 = (int)Float.parseFloat((String)wordIterator.next());
                            int wy1 = (int)Float.parseFloat((String)wordIterator.next());
                            int wx2 = (int)Float.parseFloat((String)wordIterator.next());
                            int wy2 = (int)Float.parseFloat((String)wordIterator.next());
                            output_stream.write(currentWord + ',' + wx1 + ',' + wy1 + ',' + wx2 + ',' + wy2 + '\n');
                        }
                        output_stream.close();
                    }
                    ++count;
                    status.setProgress(page + 1);
                    decode_pdf.flushObjectValues(false);
                }
                status.close();
                this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.TextSavedTo") + ' ' + output_dir);
            }
            catch (Exception e) {
                decode_pdf.closePdfFile();
                System.err.println("Exception " + e + " in " + this.selectedFile);
                e.printStackTrace();
            }
            catch (Error e) {
                e.printStackTrace();
            }
        }
        decode_pdf.closePdfFile();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeTextRectangle(int startPage, int endPage, String output_dir, boolean useXMLExtraction) {
        PdfDecoder decode_pdf = null;
        try {
            decode_pdf = new PdfDecoder(false);
            if (!useXMLExtraction) {
                decode_pdf.useTextExtraction();
            }
            decode_pdf.setExtractionMode(1);
            PdfDecoder.init(true);
            decode_pdf.openPdfFile(this.selectedFile);
        }
        catch (PdfSecurityException se) {
            System.err.println("Security Exception " + se + " in pdf code for text extraction on file ");
        }
        catch (PdfException se) {
            System.err.println("Pdf Exception " + se + " in pdf code for text extraction on file ");
        }
        catch (Exception e) {
            System.err.println("Exception " + e + " in pdf code for text extraction on file ");
            e.printStackTrace();
        }
        if (decode_pdf.isEncrypted() && !decode_pdf.isPasswordSupplied() && !decode_pdf.isExtractionAllowed()) {
            System.out.println("Encrypted settings");
            System.out.println("Please look at Viewer for code sample to handle such files");
        } else {
            ProgressMonitor status = new ProgressMonitor(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerMessage.ExtractText"), "", startPage, endPage);
            try {
                int count = 0;
                boolean yesToAll = false;
                for (int page = startPage; page < endPage + 1; ++page) {
                    File fileToSave;
                    if (status.isCanceled()) {
                        this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerError.UserStoppedExport") + count + ' ' + Messages.getMessage("PdfViewerError.ReportNumberOfPagesExported"));
                        return;
                    }
                    decode_pdf.decodePage(page);
                    PdfGroupingAlgorithms currentGrouping = decode_pdf.getGroupingObject();
                    PdfPageData currentPageData = decode_pdf.getPdfPageData();
                    int x1 = currentPageData.getMediaBoxX(page);
                    int x2 = currentPageData.getMediaBoxWidth(page) + x1;
                    int y2 = currentPageData.getMediaBoxY(page);
                    int y1 = currentPageData.getMediaBoxHeight(page) + y2;
                    String text = null;
                    try {
                        text = currentGrouping.extractTextInRectangle(x1, y1, x2, y2, page, false, true);
                    }
                    catch (PdfException e) {
                        decode_pdf.closePdfFile();
                        System.err.println("Exception " + e.getMessage() + " in file " + decode_pdf.getObjectStore().fullFileName);
                        e.printStackTrace();
                    }
                    if (text == null) continue;
                    String target = output_dir + this.separator + "rectangle" + this.separator;
                    File page_path = new File(target);
                    if (!page_path.exists()) {
                        page_path.mkdirs();
                    }
                    String prefix = "_text.txt";
                    String encoding = System.getProperty("file.encoding");
                    if (useXMLExtraction) {
                        prefix = "_xml.txt";
                        encoding = "UTF-8";
                    }
                    if ((fileToSave = new File(target + this.fileName + '_' + page + prefix)).exists() && !yesToAll) {
                        int n;
                        if (endPage - startPage > 1) {
                            n = this.currentGUI.showOverwriteDialog(fileToSave.getAbsolutePath(), true);
                            if (n != 0) {
                                if (n == 1) {
                                    yesToAll = true;
                                } else {
                                    if (n != 2) {
                                        this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerError.UserStoppedExport") + count + ' ' + Messages.getMessage("PdfViewerError.ReportNumberOfPagesExported"));
                                        status.close();
                                        return;
                                    }
                                    status.setProgress(page);
                                    continue;
                                }
                            }
                        } else {
                            n = this.currentGUI.showOverwriteDialog(fileToSave.getAbsolutePath(), false);
                            if (n != 0) {
                                return;
                            }
                        }
                    }
                    OutputStreamWriter output_stream = new OutputStreamWriter((OutputStream)new FileOutputStream(target + this.fileName + '_' + page + prefix), encoding);
                    if (useXMLExtraction) {
                        output_stream.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
                        output_stream.write("<!-- Pixel Location of text x1,y1,x2,y2\n");
                        output_stream.write("(x1,y1 is top left corner)\n");
                        output_stream.write("(x1,y1 is bottom right corner)\n");
                        output_stream.write("(origin is bottom left corner)  -->\n");
                        output_stream.write("\n\n<ARTICLE>\n");
                        output_stream.write("<LOCATION x1=\"" + x1 + "\" y1=\"" + y1 + "\" x2=\"" + x2 + "\" y2=\"" + y2 + "\" />\n");
                        output_stream.write("\n\n<TEXT>\n");
                        output_stream.write(text);
                        output_stream.write("\n\n</TEXT>\n");
                        output_stream.write("\n\n</ARTICLE>\n");
                    } else {
                        output_stream.write(text);
                    }
                    ++count;
                    output_stream.close();
                    status.setProgress(page + 1);
                    decode_pdf.flushObjectValues(true);
                }
                status.close();
                this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.TextSavedTo") + ' ' + output_dir);
            }
            catch (Exception e) {
                decode_pdf.closePdfFile();
                System.err.println("Exception " + e.getMessage());
                e.printStackTrace();
                System.out.println(decode_pdf.getObjectStore().getCurrentFilename());
            }
        }
        decode_pdf.closePdfFile();
    }
}

