/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.glyph;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.PdfDecoder;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.glyph.GlyphFactory;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.glyph.PdfGlyphs;
import org.jpedal.fonts.objects.FontData;
import org.jpedal.fonts.tt.Table;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.StringUtils;

public class PdfJavaGlyphs
implements PdfGlyphs,
Serializable {
    private static final long serialVersionUID = 7380151641871333698L;
    private Area[] cachedShapes = null;
    private AffineTransform[] cachedAt = null;
    public int[] CMAP_Translate;
    protected int glyphCount = 0;
    public boolean isFontInstalled = false;
    public String defaultFont = "Lucida Sans";
    public String fontName = "default";
    public String logicalfontName = "default";
    Map chars = new HashMap();
    Map displayValues = new HashMap();
    Map embeddedChars = new HashMap();
    private boolean isIdentity = false;
    private boolean isFontEmbedded = false;
    private boolean hasWidths = true;
    public String baseFontName = "";
    public boolean isSubsetted;
    public float[][] lastTrm = new float[3][3];
    private Font unscaledFont = null;
    public boolean isArialInstalledLocally;
    private int maxCharCount = 255;
    public boolean isCIDFont;
    public boolean remapFont = false;
    public String font_family_name;
    public int style;
    public static FontRenderContext frc = new FontRenderContext(null, true, true);
    public static String[] fontList;
    protected PdfGlyph[] cachedEmbeddedShapes = null;
    protected int localBias = 0;
    protected int globalBias = 0;

    public void flush() {
        this.cachedShapes = null;
        this.cachedAt = null;
    }

    @Override
    public String getBaseFontName() {
        return this.baseFontName;
    }

    public void setBaseFontName(String baseFontName) {
        this.baseFontName = baseFontName;
    }

    @Override
    public Area getStandardGlyph(float[][] Trm, int rawInt, String displayValue, float currentWidth, boolean isSTD) {
        Area transformedGlyph2 = this.getCachedShape(rawInt);
        if (transformedGlyph2 == null) {
            AffineTransform at;
            double dY = -1.0;
            double dX = 1.0;
            double y = 0.0;
            if (Trm[1][0] < 0.0f && Trm[0][1] >= 0.0f || Trm[0][1] < 0.0f && Trm[1][0] >= 0.0f) {
                dX = 1.0;
                dY = -1.0;
            }
            if (isSTD) {
                transformedGlyph2 = this.getGlyph(rawInt, displayValue, currentWidth);
                if (transformedGlyph2 != null && rawInt == 146 && this.isArialInstalledLocally) {
                    y = -(transformedGlyph2.getBounds().height - transformedGlyph2.getBounds().y);
                }
            } else {
                String xx = displayValue;
                if (this.remapFont && !this.getUnscaledFont().canDisplay(xx.charAt(0))) {
                    xx = String.valueOf((char)(rawInt + 61440));
                }
                GlyphVector gv1 = null;
                if (!this.isCIDFont || this.isFontInstalled) {
                    gv1 = this.getUnscaledFont().createGlyphVector(frc, xx);
                }
                if (gv1 != null) {
                    double glyphWidth;
                    double scaleFactor;
                    transformedGlyph2 = new Area(gv1.getOutline());
                    double glyphX = gv1.getOutline().getBounds2D().getX();
                    if (glyphX < 0.0) {
                        glyphX = -glyphX;
                        at = AffineTransform.getTranslateInstance(glyphX * 2.0, 0.0);
                        transformedGlyph2.transform(at);
                    }
                    if ((scaleFactor = (double)currentWidth / (glyphWidth = gv1.getVisualBounds().getWidth() + glyphX * 2.0)) < 1.0) {
                        dX *= scaleFactor;
                    }
                }
            }
            at = new AffineTransform(dX * (double)Trm[0][0], dX * (double)Trm[0][1], dY * (double)Trm[1][0], dY * (double)Trm[1][1], 0.0, y);
            if (transformedGlyph2 != null) {
                transformedGlyph2.transform(at);
            }
            this.setCachedShape(rawInt, transformedGlyph2, at);
        }
        return transformedGlyph2;
    }

    public Area getGlyph(int rawInt, String displayValue, float currentWidth) {
        boolean fontMatched = true;
        GlyphVector gv1 = null;
        String xx = displayValue;
        if (this.remapFont && !this.getUnscaledFont().canDisplay(xx.charAt(0))) {
            xx = String.valueOf((char)(rawInt + 61440));
        }
        if (!this.getUnscaledFont().canDisplay(xx.charAt(0))) {
            xx = displayValue;
            fontMatched = false;
        }
        if (this.isCIDFont && this.isFontEmbedded && fontMatched) {
            gv1 = null;
        } else if (fontMatched) {
            gv1 = this.getUnscaledFont().createGlyphVector(frc, xx);
        } else {
            Font tempFont = new Font(this.defaultFont, 0, 1);
            if (!tempFont.canDisplay(xx.charAt(0))) {
                tempFont = new Font("lucida", 0, 1);
            }
            if (tempFont.canDisplay(xx.charAt(0))) {
                gv1 = tempFont.createGlyphVector(frc, xx);
            }
        }
        Area transformedGlyph2 = null;
        if (gv1 != null) {
            transformedGlyph2 = new Area(gv1.getOutline());
            double glyphX = gv1.getOutline().getBounds2D().getX();
            double width = gv1.getOutline().getBounds2D().getWidth();
            if (!this.hasWidths) {
                float leading = (float)((double)currentWidth - (width + glyphX + glyphX)) / 2.0f;
                if (leading > 0.0f) {
                    AffineTransform at = AffineTransform.getTranslateInstance(leading, 0.0);
                    transformedGlyph2.transform(at);
                }
            } else {
                double scaleFactor;
                AffineTransform at;
                if (glyphX < 0.0) {
                    glyphX = -glyphX;
                    at = AffineTransform.getTranslateInstance(glyphX, 0.0);
                    transformedGlyph2.transform(at);
                }
                if ((scaleFactor = (double)currentWidth / transformedGlyph2.getBounds2D().getWidth()) < 1.0) {
                    at = AffineTransform.getScaleInstance(scaleFactor, 1.0);
                    transformedGlyph2.transform(at);
                }
            }
        }
        return transformedGlyph2;
    }

    public final void setCachedShape(int idx, Area shape, AffineTransform at) {
        Area[] cache = this.cachedShapes;
        AffineTransform[] atCache = this.cachedAt;
        if (cache == null) {
            this.cachedShapes = cache = new Area[this.maxCharCount];
            this.cachedAt = atCache = new AffineTransform[this.maxCharCount];
        }
        cache[idx] = shape == null ? null : shape;
        if (shape != null && at != null) {
            atCache[idx] = at;
        }
    }

    public final AffineTransform getCachedTransform(int idx) {
        AffineTransform[] cache = this.cachedAt;
        if (cache == null) {
            return null;
        }
        return cache[idx];
    }

    public final Area getCachedShape(int idx) {
        Area[] cache = this.cachedShapes;
        if (cache == null) {
            return null;
        }
        Area currentShape = cache[idx];
        if (currentShape == null) {
            return null;
        }
        return currentShape;
    }

    public void init(int maxCharCount, boolean isCIDFont) {
        this.maxCharCount = maxCharCount;
        this.isCIDFont = isCIDFont;
    }

    public final Font setFont(String name, int size) {
        int pointer;
        Font f;
        if (PdfDecoder.Helper != null && (f = PdfDecoder.Helper.setFont(this, StringUtils.convertHexChars(name), size)) != null) {
            this.style = f.getStyle();
            this.font_family_name = f.getFamily();
            this.unscaledFont = f;
            return f;
        }
        this.font_family_name = name = StandardFonts.expandName(name);
        this.style = 0;
        String weight = null;
        String mappedName = null;
        if (this.font_family_name == null) {
            this.font_family_name = this.fontName;
        }
        String testFont = this.font_family_name;
        if (this.font_family_name != null) {
            testFont = this.font_family_name.toLowerCase();
        }
        if ((pointer = this.font_family_name.indexOf(44)) == -1) {
            pointer = this.font_family_name.indexOf(45);
        }
        if (pointer != -1) {
            mappedName = FontMappings.fontSubstitutionAliasTable.get(testFont);
            weight = testFont.substring(pointer + 1, testFont.length());
            this.style = PdfJavaGlyphs.getWeight(weight);
            this.font_family_name = this.font_family_name.substring(0, pointer).toLowerCase();
            testFont = this.font_family_name;
            if (testFont.endsWith("mt")) {
                testFont = testFont.substring(0, testFont.length() - 2);
            }
        }
        if (mappedName == null) {
            mappedName = FontMappings.fontSubstitutionAliasTable.get(testFont);
        }
        if (mappedName != null && mappedName.equals("arialbd")) {
            mappedName = "arial-bold";
        }
        if (mappedName != null) {
            this.font_family_name = mappedName;
            pointer = this.font_family_name.indexOf(45);
            if (pointer != -1) {
                this.font_family_name = this.font_family_name.toLowerCase();
                weight = this.font_family_name.substring(pointer + 1, this.font_family_name.length());
                this.style = PdfJavaGlyphs.getWeight(weight);
                this.font_family_name = this.font_family_name.substring(0, pointer);
            }
            if ((testFont = this.font_family_name.toLowerCase()).endsWith("mt")) {
                testFont = testFont.substring(0, testFont.length() - 2);
            }
        }
        if (fontList != null) {
            int i;
            boolean isFound = false;
            int count = fontList.length;
            for (i = 0; i < count; ++i) {
                if (!fontList[i].equals(testFont) && (weight != null || !testFont.startsWith(fontList[i]))) continue;
                this.isFontInstalled = true;
                this.font_family_name = fontList[i];
                i = count;
                isFound = true;
            }
            if (!isFound) {
                count = fontList.length;
                for (i = 0; i < count; ++i) {
                    if (!fontList[i].equals(testFont) && (weight != null || !testFont.startsWith(fontList[i]))) continue;
                    this.isFontInstalled = true;
                    this.font_family_name = fontList[i];
                    i = count;
                }
            }
            if (this.isFontInstalled && this.font_family_name.equals("arial")) {
                this.isArialInstalledLocally = true;
            }
        }
        if (!this.isFontInstalled) {
            if (weight == null) {
                String test = this.font_family_name.toLowerCase();
                this.style = PdfJavaGlyphs.getWeight(test);
            }
            this.font_family_name = this.defaultFont;
        }
        this.unscaledFont = new Font(this.font_family_name, this.style, size);
        return this.unscaledFont;
    }

    private static int getWeight(String weight) {
        int style = 0;
        if (weight.endsWith("mt")) {
            weight = weight.substring(0, weight.length() - 2);
        }
        if (weight.contains("heavy")) {
            style = 1;
        } else if (weight.contains("bold")) {
            style = 1;
        } else if (weight.contains("roman")) {
            style = 0;
        }
        if (weight.contains("italic")) {
            style += 2;
        } else if (weight.contains("oblique")) {
            style += 2;
        }
        return style;
    }

    public final Font getUnscaledFont() {
        if (this.unscaledFont == null) {
            this.unscaledFont = new Font(this.defaultFont, 0, 1);
        }
        return this.unscaledFont;
    }

    public final void setEmbeddedCachedShape(int idx, PdfGlyph shape) {
        PdfGlyph[] cache = this.cachedEmbeddedShapes;
        if (cache == null) {
            this.cachedEmbeddedShapes = cache = new PdfGlyph[this.maxCharCount];
        }
        if (idx < cache.length) {
            cache[idx] = shape;
        }
    }

    public final PdfGlyph getEmbeddedCachedShape(int idx) {
        PdfGlyph[] cache = this.cachedEmbeddedShapes;
        if (cache == null) {
            return null;
        }
        if (idx < cache.length) {
            PdfGlyph currentShape = cache[idx];
            if (currentShape == null) {
                return null;
            }
            return currentShape;
        }
        return null;
    }

    @Override
    public PdfGlyph getEmbeddedGlyph(GlyphFactory factory, String glyph, float[][] trm, int rawInt, String displayValue, float currentWidth, String key) {
        return null;
    }

    public void setGIDtoCID(int[] cidToGIDMap) {
    }

    public void setEncodingToUse(boolean hasEncoding, int fontEncoding, boolean b, boolean isCIDFont) {
    }

    public int readEmbeddedFont(boolean TTstreamisCID, byte[] fontDataAsArray, FontData fontData) {
        return 0;
    }

    public void setIsSubsetted(boolean b) {
        this.isSubsetted = b;
    }

    public void setT3Glyph(int key, int altKey, PdfGlyph glyph) {
    }

    public void setCharString(String s, byte[] bytes, int glyphNo) {
    }

    public int getNumber(FontData fontData, int p, double[] op, int i, boolean b) {
        return 0;
    }

    public int getNumber(byte[] fontDataAsArray, int p, double[] op, int i, boolean b) {
        return 0;
    }

    public boolean is1C() {
        return false;
    }

    public void setis1C(boolean b) {
    }

    public void setValuesForGlyph(int rawInt, String charGlyph, String displayValue, String embeddedChar) {
        Integer key = rawInt;
        this.chars.put(key, charGlyph);
        this.displayValues.put(key, displayValue);
        this.embeddedChars.put(key, embeddedChar);
    }

    @Override
    public String getDisplayValue(Integer key) {
        return (String)this.displayValues.get(key);
    }

    @Override
    public String getCharGlyph(Integer key) {
        return (String)this.chars.get(key);
    }

    @Override
    public String getEmbeddedEnc(Integer key) {
        return (String)this.embeddedChars.get(key);
    }

    public Map getDisplayValues() {
        return this.displayValues;
    }

    public Map getCharGlyphs() {
        return this.chars;
    }

    public Map getEmbeddedEncs() {
        return this.embeddedChars;
    }

    public void setDisplayValues(Map displayValues) {
        this.displayValues = displayValues;
    }

    public void setCharGlyphs(Map chars) {
        this.chars = chars;
    }

    public void setEmbeddedEncs(Map embeddedChars) {
        this.embeddedChars = embeddedChars;
    }

    public void setLocalBias(int i) {
        this.localBias = i;
    }

    public void setGlobalBias(int i) {
        this.globalBias = i;
    }

    public float getTTWidth(String charGlyph, int rawInt, String displayValue, boolean b) {
        return 0.0f;
    }

    public static String getPostName(int rawInt) {
        return "notdef";
    }

    public int getConvertedGlyph(int rawInt) {
        return -1;
    }

    public void setIsIdentity(boolean isIdentity) {
        this.isIdentity = isIdentity;
    }

    public boolean isIdentity() {
        return this.isIdentity;
    }

    public float[] getFontBoundingBox() {
        return new float[]{0.0f, 0.0f, 1000.0f, 1000.0f};
    }

    public void setFontEmbedded(boolean isSet) {
        this.isFontEmbedded = isSet;
    }

    public int getType() {
        return 0;
    }

    public void setHasWidths(boolean hasWidths) {
        this.hasWidths = hasWidths;
    }

    public void setDiffValues(String[] diffTable) {
    }

    public int getCMAPValue(int rawInt) {
        if (this.CMAP_Translate == null) {
            return -1;
        }
        return this.CMAP_Translate[rawInt];
    }

    public boolean isCorrupted() {
        return false;
    }

    public void setCorrupted(boolean corrupt) {
    }

    public void setIndexForCharString(int jj, String glyphName) {
    }

    public String getIndexForCharString(int jj) {
        return null;
    }

    public Map getCharStrings() {
        return null;
    }

    public void setGlyphCount(int nGlyphs) {
        this.glyphCount = nGlyphs;
    }

    public int getGlyphCount() {
        return this.glyphCount;
    }

    public void setRenderer(DynamicVectorRenderer current) {
    }

    public Table getTable(int LOCA) {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

