/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Glyf;
import org.jpedal.fonts.tt.Table;
import org.jpedal.utils.LogWriter;

public class CMAP
extends Table {
    private static final long serialVersionUID = 649534827911949122L;
    protected int[][] glyphIndexToChar;
    private int[] glyphToIndex;
    private boolean hasSix = false;
    private boolean hasFormat4 = false;
    private boolean hasFormat6 = false;
    private int lastFormat4Found = -1;
    private int firstCode = -1;
    private int entryCount = -1;
    private int winScore = 0;
    private int macScore = 0;
    private int segCount = 0;
    private int fontMapping = 0;
    protected int[] endCode;
    protected int[] startCode;
    protected int[] idDelta;
    protected int[] idRangeOffset;
    protected int[] glyphIdArray;
    private int[] f6glyphIdArray;
    private int[] offset;
    int nGroups;
    private int[] startCharCode;
    private int[] endCharCode;
    private int[] startGlyphCode;
    protected int[] CMAPformats;
    protected int[] CMAPlength;
    protected int[] CMAPlang;
    protected int[] CMAPsegCount;
    protected int[] CMAPsearchRange;
    protected int[] CMAPentrySelector;
    protected int[] CMAPrangeShift;
    protected int[] CMAPreserved;
    private boolean maybeWinEncoded = false;
    protected int[] platformID;
    private static Map exceptions = new HashMap();
    private int formatToUse;
    private int encodingToUse = 0;
    private static boolean WINchecked;
    protected int id;
    protected int numberSubtables;
    protected int[] CMAPsubtables;
    protected int[] platformSpecificID;

    public CMAP(FontFile2 currentFontFile, int startPointer, Glyf currentGlyf) {
        boolean debug = false;
        if (startPointer == 0) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("No CMAP table found");
            }
        } else {
            this.id = currentFontFile.getNextUint16();
            this.numberSubtables = currentFontFile.getNextUint16();
            this.CMAPsubtables = new int[this.numberSubtables];
            this.platformID = new int[this.numberSubtables];
            this.platformSpecificID = new int[this.numberSubtables];
            this.CMAPformats = new int[this.numberSubtables];
            this.CMAPsearchRange = new int[this.numberSubtables];
            this.CMAPentrySelector = new int[this.numberSubtables];
            this.CMAPrangeShift = new int[this.numberSubtables];
            this.CMAPreserved = new int[this.numberSubtables];
            this.CMAPsegCount = new int[this.numberSubtables];
            this.CMAPlength = new int[this.numberSubtables];
            this.CMAPlang = new int[this.numberSubtables];
            this.glyphIndexToChar = new int[this.numberSubtables][256];
            this.glyphToIndex = new int[256];
            for (int i = 0; i < this.numberSubtables; ++i) {
                this.platformID[i] = currentFontFile.getNextUint16();
                this.platformSpecificID[i] = currentFontFile.getNextUint16();
                this.CMAPsubtables[i] = currentFontFile.getNextUint32();
            }
            for (int j = 0; j < this.numberSubtables; ++j) {
                currentFontFile.selectTable(2);
                currentFontFile.skip(this.CMAPsubtables[j]);
                this.CMAPformats[j] = currentFontFile.getNextUint16();
                this.CMAPlength[j] = currentFontFile.getNextUint16();
                this.CMAPlang[j] = currentFontFile.getNextUint16();
                if (this.CMAPformats[j] == 6) {
                    this.hasSix = true;
                }
                if (this.CMAPformats[j] == 0 && this.CMAPlength[j] == 262) {
                    StandardFonts.checkLoaded(2);
                    StandardFonts.checkLoaded(0);
                    for (int glyphNum = 0; glyphNum < 256; ++glyphNum) {
                        boolean isValidOnWin;
                        int index;
                        this.glyphIndexToChar[j][glyphNum] = index = currentFontFile.getNextUint8();
                        this.glyphToIndex[index] = glyphNum;
                        if (index <= 0) continue;
                        boolean isValidOnMac = StandardFonts.isValidMacEncoding(glyphNum);
                        if (isValidOnMac != (isValidOnWin = StandardFonts.isValidWinEncoding(glyphNum))) {
                            this.maybeWinEncoded = true;
                        }
                        if (isValidOnMac) {
                            ++this.macScore;
                        }
                        if (!isValidOnWin) continue;
                        ++this.winScore;
                    }
                    continue;
                }
                if (this.CMAPformats[j] == 4) {
                    int i;
                    this.CMAPsegCount[j] = currentFontFile.getNextUint16();
                    this.segCount = this.CMAPsegCount[j] / 2;
                    this.CMAPsearchRange[j] = currentFontFile.getNextUint16();
                    this.CMAPentrySelector[j] = currentFontFile.getNextUint16();
                    this.CMAPrangeShift[j] = currentFontFile.getNextUint16();
                    if (this.hasFormat4) {
                        if (this.CMAPlength[this.lastFormat4Found] > this.CMAPlength[j]) {
                            this.CMAPlength[j] = this.CMAPlength[this.lastFormat4Found];
                            this.CMAPsegCount[j] = this.CMAPsegCount[this.lastFormat4Found];
                            this.CMAPsearchRange[j] = this.CMAPsearchRange[this.lastFormat4Found];
                            this.CMAPentrySelector[j] = this.CMAPentrySelector[this.lastFormat4Found];
                            this.CMAPrangeShift[j] = this.CMAPrangeShift[this.lastFormat4Found];
                            continue;
                        }
                        if (this.CMAPlength[this.lastFormat4Found] < this.CMAPlength[j]) {
                            this.CMAPlength[this.lastFormat4Found] = this.CMAPlength[j];
                            this.CMAPsegCount[this.lastFormat4Found] = this.CMAPsegCount[j];
                            this.CMAPsearchRange[this.lastFormat4Found] = this.CMAPsearchRange[j];
                            this.CMAPentrySelector[this.lastFormat4Found] = this.CMAPentrySelector[j];
                            this.CMAPrangeShift[this.lastFormat4Found] = this.CMAPrangeShift[j];
                        }
                    }
                    this.lastFormat4Found = j;
                    this.hasFormat4 = true;
                    this.endCode = new int[this.segCount];
                    for (i = 0; i < this.segCount; ++i) {
                        this.endCode[i] = currentFontFile.getNextUint16();
                    }
                    this.CMAPreserved[j] = currentFontFile.getNextUint16();
                    this.startCode = new int[this.segCount];
                    for (i = 0; i < this.segCount; ++i) {
                        this.startCode[i] = currentFontFile.getNextUint16();
                    }
                    this.idDelta = new int[this.segCount];
                    for (i = 0; i < this.segCount; ++i) {
                        this.idDelta[i] = currentFontFile.getNextUint16();
                    }
                    this.idRangeOffset = new int[this.segCount];
                    for (i = 0; i < this.segCount; ++i) {
                        this.idRangeOffset[i] = currentFontFile.getNextUint16();
                    }
                    this.offset = new int[this.segCount];
                    int cumulative = 0;
                    for (int i2 = 0; i2 < this.segCount; ++i2) {
                        if (this.idDelta[i2] != 0) continue;
                        this.offset[i2] = cumulative;
                        int diff = 1 + this.endCode[i2] - this.startCode[i2];
                        if (this.startCode[i2] == this.endCode[i2] && this.idRangeOffset[i2] == 0) {
                            diff = 0;
                        }
                        cumulative += diff;
                    }
                    int count = (this.CMAPlength[j] - 16 - this.segCount * 8) / 2;
                    this.glyphIdArray = new int[count];
                    for (int i3 = 0; i3 < count; ++i3) {
                        this.glyphIdArray[i3] = currentFontFile.getNextUint16();
                    }
                    continue;
                }
                if (this.CMAPformats[j] == 6) {
                    this.hasFormat6 = true;
                    this.firstCode = currentFontFile.getNextUint16();
                    this.entryCount = currentFontFile.getNextUint16();
                    this.f6glyphIdArray = new int[this.firstCode + this.entryCount];
                    for (int jj = 0; jj < this.entryCount; ++jj) {
                        this.f6glyphIdArray[jj + this.firstCode] = currentFontFile.getNextUint16();
                    }
                    continue;
                }
                if (this.CMAPformats[j] == 12) {
                    currentFontFile.getNextUint16();
                    currentFontFile.getNextUint32();
                    this.nGroups = currentFontFile.getNextUint32();
                    this.startCharCode = new int[this.nGroups];
                    this.endCharCode = new int[this.nGroups];
                    this.startGlyphCode = new int[this.nGroups];
                    for (int ii = 0; ii < this.nGroups; ++ii) {
                        this.startCharCode[ii] = currentFontFile.getNextUint32();
                        this.endCharCode[ii] = currentFontFile.getNextUint32();
                        this.startGlyphCode[ii] = currentFontFile.getNextUint32();
                    }
                    continue;
                }
                this.CMAPformats[j] = -1;
            }
        }
    }

    public CMAP() {
    }

    public int convertIndexToCharacterCode(String glyph, int index, boolean remapFont, boolean isSubsetted, String[] diffTable) {
        int index2 = -1;
        int rawIndex = index;
        int format = this.CMAPformats[this.formatToUse];
        boolean debugMapping = false;
        if ((this.fontMapping == 1 || !remapFont && this.fontMapping == 4) && glyph != null && !"notdef".equals(glyph)) {
            index = StandardFonts.getAdobeMap(glyph);
        } else if (this.fontMapping == 2) {
            StandardFonts.checkLoaded(this.encodingToUse);
            if (this.encodingToUse == 0) {
                block28: {
                    Object exception = null;
                    if (glyph != null) {
                        exception = exceptions.get(glyph);
                    }
                    if (exception == null) {
                        if (glyph != null && !isSubsetted) {
                            index = StandardFonts.lookupCharacterIndex(glyph, this.encodingToUse);
                        }
                    } else if (diffTable == null || diffTable[index] == null) {
                        try {
                            index = Integer.parseInt(exception);
                        }
                        catch (Exception e) {
                            if (!LogWriter.isOutput()) break block28;
                            LogWriter.writeLog("Exception: " + e.getMessage());
                        }
                    }
                }
                if (glyph != null) {
                    if (!WINchecked) {
                        StandardFonts.checkLoaded(2);
                        WINchecked = true;
                    }
                    index2 = StandardFonts.lookupCharacterIndex(glyph, 2);
                }
            } else if (glyph != null) {
                index = StandardFonts.lookupCharacterIndex(glyph, this.encodingToUse);
            }
        }
        int value = -1;
        if (remapFont && format > 0 && format != 6) {
            index += 61440;
        }
        if (format == 0) {
            if (index > 255) {
                index = 0;
            }
            if ((value = this.glyphIndexToChar[this.formatToUse][index]) == 0 && index2 != -1) {
                value = this.glyphIndexToChar[this.formatToUse][index2];
            }
            if (rawIndex == 128 && this.endCode != null && "Euro".equals(glyph)) {
                value = this.getFormat4Value(8364, false, value);
            }
        } else if (format == 4) {
            if ((value = this.getFormat4Value(index, false, value)) == -1) {
                value = index > 61440 ? this.getFormat4Value(index - 61440, false, value) : this.getFormat4Value(index + 61440, false, value);
            }
        } else if (format == 12) {
            value = this.getFormat12Value(index, false, value);
        }
        if (value == -1 && this.hasSix) {
            index = rawIndex;
            format = 6;
        }
        if (format == 6) {
            if (!remapFont) {
                index = StandardFonts.lookupCharacterIndex(glyph, this.encodingToUse);
            }
            value = index >= this.f6glyphIdArray.length ? 0 : this.f6glyphIdArray[index];
        }
        return value;
    }

    private int getFormat12Value(int index, boolean debugMapping, int value) {
        for (int i = 0; i < this.nGroups; ++i) {
            if (debugMapping) {
                System.out.println("table=" + i + " start=" + this.startCharCode[i] + ' ' + index + " end=" + this.endCharCode[i] + " glypgStartCode[i]=" + this.startGlyphCode[i]);
            }
            if (this.endCharCode[i] < index || this.startCharCode[i] > index) continue;
            value = this.startGlyphCode[i] + index - this.startCharCode[i];
            i = this.nGroups;
        }
        return value;
    }

    private int getFormat4Value(int index, boolean debugMapping, int value) {
        for (int i = 0; i < this.segCount; ++i) {
            if (debugMapping) {
                System.out.println("Segtable=" + i + " start=" + this.startCode[i] + ' ' + index + " end=" + this.endCode[i] + " idRangeOffset[i]=" + this.idRangeOffset[i] + " offset[i]=" + this.offset[i] + " idRangeOffset[i]=" + this.idRangeOffset[i] + " idDelta[i]=" + this.idDelta[i]);
            }
            if (this.endCode[i] < index || this.startCode[i] > index) continue;
            if (this.idRangeOffset[i] == 0) {
                if (debugMapping) {
                    System.out.println("xxx=" + (this.idDelta[i] + index));
                }
                value = (this.idDelta[i] + index) % 65536;
                i = this.segCount;
                continue;
            }
            int idx = this.offset[i] + (index - this.startCode[i]);
            value = this.glyphIdArray[idx];
            if (debugMapping) {
                System.out.println("value=" + value + " idx=" + idx + " glyphIdArrays=" + this.glyphIdArray[0] + ' ' + this.glyphIdArray[1] + ' ' + this.glyphIdArray[2] + " offset[i]=" + this.offset[i] + " index=" + index + " startCode[" + i + "]=" + this.startCode[i] + " i=" + i);
            }
            i = this.segCount;
        }
        return value;
    }

    public void setEncodingToUse(boolean hasEncoding, int fontEncoding, boolean isSubstituted, boolean isCID) {
        int i;
        boolean encodingDebug = false;
        this.formatToUse = -1;
        int count = this.platformID.length;
        if (!(isSubstituted || this.macScore >= 207 || this.glyphToIndex != null && this.macScore > 90 && !this.maybeWinEncoded || this.glyphToIndex != null && this.macScore > 205 && this.glyphToIndex[138] != 0 && this.glyphToIndex[228] == 0)) {
            if (count > 0 && this.winScore > this.macScore) {
                this.encodingToUse = 2;
            }
            if (this.macScore > 80 && hasEncoding && fontEncoding == 2 && this.winScore >= this.macScore) {
                this.encodingToUse = 2;
            }
        }
        for (int i2 = 0; i2 < count; ++i2) {
            if (this.platformID[i2] != 3 || this.CMAPformats[i2] != 1 && this.CMAPformats[i2] != 0) continue;
            this.formatToUse = i2;
            this.fontMapping = 1;
            i2 = count;
        }
        boolean wasCase2 = false;
        if (this.formatToUse == -1 && this.CMAPformats[0] != 12 && (this.macScore > 0 && this.winScore > 0 || this.CMAPformats.length == 1) && !isCID && (!isSubstituted || this.CMAPformats.length == 1 && this.CMAPformats[0] == 0)) {
            for (int i3 = 0; i3 < count; ++i3) {
                if (this.platformID[i3] != 1 || this.CMAPformats[i3] != 0) continue;
                this.formatToUse = i3;
                this.fontMapping = hasEncoding || fontEncoding == 2 ? 2 : 3;
                i3 = count;
                wasCase2 = true;
            }
        }
        boolean wasCase3 = false;
        if (this.formatToUse == -1) {
            for (i = 0; i < count; ++i) {
                if (this.CMAPformats[i] != 6) continue;
                this.formatToUse = i;
                if (!hasEncoding && fontEncoding == 2) {
                    this.fontMapping = 2;
                    StandardFonts.checkLoaded(0);
                } else {
                    this.fontMapping = 6;
                }
                wasCase3 = true;
                i = count;
            }
        }
        if (this.formatToUse == -1 || wasCase3 || wasCase2 && (this.glyphIndexToChar[this.formatToUse][223] == 0 || this.getFormat4Value(223, false, 0) != 0)) {
            for (i = 0; i < count; ++i) {
                if (this.CMAPformats[i] != 4) continue;
                this.formatToUse = i;
                this.fontMapping = 4;
                i = count;
            }
        }
        if (this.formatToUse == -1) {
            for (i = 0; i < count; ++i) {
                if (this.CMAPformats[i] != 12) continue;
                this.formatToUse = i;
                if (!hasEncoding && fontEncoding == 2) {
                    this.fontMapping = 2;
                    StandardFonts.checkLoaded(0);
                } else {
                    this.fontMapping = 12;
                }
                i = count;
            }
        }
        if (fontEncoding == 5) {
            this.fontMapping = 2;
        }
        if (this.encodingToUse == 2 && this.macScore == this.winScore && this.glyphIndexToChar[this.formatToUse][146] == 0 && this.glyphIndexToChar[this.formatToUse][213] != 0) {
            this.encodingToUse = 0;
        }
        if (this.encodingToUse == 2 && this.macScore == this.winScore && this.glyphIndexToChar[this.formatToUse][228] == 0 && this.glyphIndexToChar[this.formatToUse][138] != 0) {
            this.encodingToUse = 0;
        }
    }

    public Map buildCharStringTable() {
        HashMap<Integer, Integer> glyfValues = new HashMap<Integer, Integer>();
        if (this.hasFormat4) {
            ArrayList<Integer> list4 = new ArrayList<Integer>();
            for (int z = 0; z < this.segCount; ++z) {
                int total = this.endCode[z] - this.startCode[z] + 1;
                for (int q = 0; q < total; ++q) {
                    list4.add(this.startCode[z] + q);
                }
            }
            for (Integer i : list4) {
                glyfValues.put(i, this.getFormat4Value(i, false, 0));
            }
        } else if (this.hasFormat6) {
            for (int z = 0; z < this.entryCount; ++z) {
                glyfValues.put(this.firstCode + z, this.f6glyphIdArray[this.firstCode + z]);
            }
        } else {
            for (int z = 0; z < this.glyphToIndex.length; ++z) {
                if (this.glyphToIndex[z] <= 0) continue;
                glyfValues.put(this.glyphToIndex[z], z);
            }
        }
        return glyfValues;
    }

    public boolean hasFormat4() {
        return this.hasFormat4;
    }

    static {
        String[] values = new String[]{"notequal", "173", "infinity", "176", "lessequal", "178", "greaterequal", "179", "partialdiff", "182", "summation", "183", "product", "184", "pi", "185", "integral", "186", "Omega", "189", "radical", "195", "approxequal", "197", "Delta", "198", "lozenge", "215", "Euro", "219", "apple", "240"};
        for (int i = 0; i < values.length; i += 2) {
            exceptions.put(values[i], values[i + 1]);
        }
    }
}

