/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import java.util.HashMap;
import java.util.Map;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Table;

public class Glyf
extends Table {
    private static final long serialVersionUID = -1163555956748847206L;
    private Map charStrings = new HashMap();
    private int glyfCount = 0;
    private Map emptyCharStrings = new HashMap();
    private byte[] glyphTable;

    public Glyf(FontFile2 currentFontFile, int glyphCount, int[] glyphIndexStart) {
        this.glyfCount = glyphCount;
        int startPointer = currentFontFile.selectTable(3);
        if (startPointer != 0) {
            for (int i = 0; i < glyphCount; ++i) {
                if (glyphIndexStart[i] == glyphIndexStart[i + 1]) {
                    this.charStrings.put(i, -1);
                    this.emptyCharStrings.put(i, "x");
                    continue;
                }
                this.charStrings.put(i, glyphIndexStart[i]);
            }
            this.glyphTable = currentFontFile.getTableBytes(4);
        }
    }

    public boolean isPresent(int glyph) {
        Integer key = glyph;
        Object value = this.charStrings.get(key);
        return value != null && this.emptyCharStrings.get(key) == null;
    }

    public int getCharString(int glyph) {
        Object value = this.charStrings.get(glyph);
        if (value == null) {
            return glyph;
        }
        return (Integer)value;
    }

    public byte[] getTableData() {
        return this.glyphTable;
    }

    public int getGlypfCount() {
        return this.glyfCount;
    }

    public Map buildCharStringTable(int enc) {
        HashMap returnStrings = new HashMap();
        for (Object key : this.charStrings.keySet()) {
            if (this.emptyCharStrings.containsKey(key)) continue;
            returnStrings.put(key, key);
        }
        return returnStrings;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Glyf [");
        if (this.charStrings != null) {
            builder.append("charStrings=");
            builder.append(this.charStrings);
            builder.append(", ");
        }
        builder.append("glyfCount=");
        builder.append(this.glyfCount);
        builder.append(", ");
        if (this.emptyCharStrings != null) {
            builder.append("emptyCharStrings=");
            builder.append(this.emptyCharStrings);
            builder.append(", ");
        }
        if (this.glyphTable != null) {
            builder.append("glyphTable=");
            builder.append(new String(this.glyphTable));
        }
        builder.append("]");
        return builder.toString();
    }
}

