/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.exception.PdfSecurityException;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.ObjectUtils;
import org.jpedal.io.PdfFileReader;
import org.jpedal.objects.raw.OCObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.NumberUtils;
import org.jpedal.utils.StringUtils;

public class ArrayDecoder
extends ObjectDecoder {
    private static final long serialVersionUID = 8797304649862134871L;
    private float[] floatValues = null;
    private int[] intValues = null;
    private double[] doubleValues = null;
    private byte[][] mixedValues = null;
    private byte[][] keyValues = null;
    private byte[][] stringValues = null;
    private boolean[] booleanValues = null;
    private Object[] objectValues = null;
    private int i;
    private int endPoint;
    private int type;
    private int keyReached = -1;
    private Object[] objectValuesArray = null;

    public ArrayDecoder(PdfFileReader pdfFileReader, int i, int endPoint, int type) {
        super(pdfFileReader);
        this.i = i;
        this.endPoint = endPoint;
        this.type = type;
    }

    public ArrayDecoder(PdfFileReader pdfFileReader, int i, int endPoint, int type, Object[] objectValuesArray, int keyReached) {
        super(pdfFileReader);
        this.i = i;
        this.endPoint = endPoint;
        this.type = type;
        this.objectValuesArray = objectValuesArray;
        this.keyReached = keyReached;
    }

    public int readArray(boolean ignoreRecursion, byte[] raw, PdfObject pdfObject, int PDFkeyInt) {
        boolean isIndirect;
        if ((this.type != 14 || raw[this.i] != 60) && raw[this.i] != 91 && raw[this.i] != 60) {
            ++this.i;
        }
        if (raw[this.i] == 91 && raw[this.i + 1] == 93) {
            return this.i + 1;
        }
        HashMap<Integer, String> isRef = new HashMap<Integer, String>();
        boolean isHexString = false;
        boolean alwaysRead = PDFkeyInt == 456733763 || PDFkeyInt == 1044338049;
        boolean debugArray = false;
        int currentElement = 0;
        int elementCount = 0;
        while (raw[this.i] == 10 || raw[this.i] == 13 || raw[this.i] == 32) {
            ++this.i;
        }
        if (raw[this.i] == 37) {
            this.skipComment(raw);
        }
        int keyStart = this.i;
        int j2 = this.i;
        byte[] arrayData = raw;
        boolean bl = isIndirect = raw[this.i] != 91 && raw[this.i] != 40 && PDFkeyInt != 489767739 && PDFkeyInt != 9250 && raw[0] != 0;
        if (raw[this.i] == 110 && raw[this.i + 1] == 117 && raw[this.i + 2] == 108 && raw[this.i + 2] == 108) {
            isIndirect = false;
            elementCount = 1;
        }
        if (isIndirect) {
            isIndirect = this.handleIndirect(this.endPoint, raw, false);
        }
        boolean isSingleKey = false;
        boolean isSingleDirectValue = false;
        boolean isSingleNull = true;
        int endPtr = -1;
        if ((raw[this.i] == 47 || raw[this.i] == 40 || raw[this.i] == 60 || raw[this.i] == 60 && raw[this.i + 1] == 102 && raw[this.i + 2] == 101 && raw[this.i + 3] == 102 && raw[this.i + 4] == 102) && this.type != 20 && PDFkeyInt != 9250) {
            elementCount = 1;
            isSingleKey = true;
        } else {
            int endI = -1;
            if (isIndirect) {
                int startI = this.i;
                while (raw[this.i] != 10 && raw[this.i] != 13 && raw[this.i] != 32 && raw[this.i] != 47 && raw[this.i] != 60 && raw[this.i] != 62) {
                    ++this.i;
                }
                int ref = NumberUtils.parseInt(keyStart, this.i, raw);
                while (raw[this.i] == 10 || raw[this.i] == 13 || raw[this.i] == 32 || raw[this.i] == 47 || raw[this.i] == 60) {
                    ++this.i;
                }
                keyStart = this.i;
                while (raw[this.i] != 10 && raw[this.i] != 13 && raw[this.i] != 32 && raw[this.i] != 47 && raw[this.i] != 60 && raw[this.i] != 62) {
                    ++this.i;
                }
                int generation = NumberUtils.parseInt(keyStart, this.i, raw);
                while (raw[this.i] == 10 || raw[this.i] == 13 || raw[this.i] == 32 || raw[this.i] == 47 || raw[this.i] == 60) {
                    ++this.i;
                }
                if (raw[this.i] != 82) {
                    throw new RuntimeException(padding + "4. Unexpected value " + (char)raw[this.i] + " in file - please send to IDRsolutions for analysis");
                }
                if (ignoreRecursion && !alwaysRead) {
                    return this.i;
                }
                arrayData = this.objectReader.readObjectAsByteArray(pdfObject, this.objectReader.isCompressed(ref, generation), ref, generation);
                if (arrayData == null) {
                    pdfObject.setFullyResolved(false);
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("[Linearized] " + pdfObject.getObjectRefAsString() + " not yet available (14)");
                    }
                    return raw.length;
                }
                j2 = 0;
                while (arrayData[j2] != 91) {
                    if (arrayData[j2] == 37) {
                        while (arrayData[++j2] != 13 && arrayData[j2] != 10) {
                        }
                        while (arrayData[j2] == 13 || arrayData[j2] == 10) {
                            ++j2;
                        }
                        --j2;
                    }
                    if (arrayData[j2] == 110 && arrayData[j2 + 1] == 117 && arrayData[j2 + 2] == 108 && arrayData[j2 + 3] == 108) break;
                    if (arrayData[j2] == 47) {
                        --j2;
                        isSingleDirectValue = true;
                        break;
                    }
                    if (arrayData[j2] == 60 && arrayData[j2 + 1] == 60 || j2 + 4 < arrayData.length && arrayData[j2 + 3] == 60 && arrayData[j2 + 4] == 60) {
                        endI = this.i;
                        j2 = startI;
                        arrayData = raw;
                        break;
                    }
                    ++j2;
                }
            }
            if (j2 < 0) {
                j2 = 0;
            }
            boolean startFound = false;
            while (arrayData[j2] == 10 || arrayData[j2] == 13 || arrayData[j2] == 32 || arrayData[j2] == 91 && !startFound) {
                if (arrayData[j2] == 91) {
                    startFound = true;
                }
                ++j2;
            }
            endPtr = j2;
            boolean lastCharIsSpace = true;
            int arrayEnd = arrayData.length;
            while (endPtr < arrayEnd && arrayData[endPtr] != 93) {
                boolean isRecursive = false;
                while (arrayData[endPtr] == 60 && arrayData[endPtr + 1] == 60) {
                    int levels = 1;
                    ++elementCount;
                    while (levels > 0) {
                        if (arrayData[++endPtr] == 60 && arrayData[endPtr + 1] == 60) {
                            ++endPtr;
                            ++levels;
                            continue;
                        }
                        if (arrayData[endPtr] != 62 || arrayData[endPtr - 1] != 62) continue;
                        ++endPtr;
                        --levels;
                    }
                    if (this.type != 14) continue;
                    --endPtr;
                }
                if (this.type != 18 && arrayData[endPtr] == 110 && arrayData[endPtr + 1] == 117 && arrayData[endPtr + 2] == 108 && arrayData[endPtr + 3] == 108) {
                    int nextChar = 93;
                    if (PDFkeyInt == 826881374 || PDFkeyInt == 1110717793) {
                        for (int aa = endPtr + 3; aa < arrayData.length; ++aa) {
                            if (arrayData[aa] == 10 || arrayData[aa] == 13 || arrayData[aa] == 32 || arrayData[aa] == 9) continue;
                            nextChar = arrayData[aa];
                            aa = arrayData.length;
                        }
                    }
                    if (nextChar == 93) {
                        isSingleNull = true;
                        elementCount = 1;
                        break;
                    }
                    isSingleNull = false;
                    endPtr += 4;
                    lastCharIsSpace = true;
                    continue;
                }
                if (isSingleDirectValue && (arrayData[endPtr] == 32 || arrayData[endPtr] == 13 || arrayData[endPtr] == 10) || endI != -1 && endPtr > endI) break;
                if (this.type == 14) {
                    if (arrayData[endPtr] == 82 || (PDFkeyInt == 9250 || PDFkeyInt == 1248888446) && arrayData[endPtr] == 47) {
                        ++elementCount;
                    }
                } else if (arrayData[endPtr] == 40) {
                    ++elementCount;
                    while (arrayData[endPtr] != 41 || ObjectUtils.isEscaped(arrayData, endPtr)) {
                        ++endPtr;
                        lastCharIsSpace = true;
                    }
                } else if (arrayData[endPtr] == 60) {
                    ++elementCount;
                    while (arrayData[endPtr] != 62) {
                        ++endPtr;
                        lastCharIsSpace = true;
                    }
                } else if (arrayData[endPtr] == 91) {
                    ++elementCount;
                    int level = 1;
                    while (++endPtr != arrayData.length) {
                        if (arrayData[endPtr] == 93) {
                            --level;
                        } else if (arrayData[endPtr] == 91) {
                            ++level;
                        }
                        if (level != 0) continue;
                    }
                    isRecursive = true;
                    lastCharIsSpace = true;
                } else {
                    boolean charIsSpace;
                    boolean bl2 = charIsSpace = arrayData[endPtr] == 10 || arrayData[endPtr] == 13 || arrayData[endPtr] == 32 || arrayData[endPtr] == 47;
                    if (lastCharIsSpace && !charIsSpace) {
                        if ((this.type == 18 || this.type == 22) && arrayData[endPtr] == 82 && arrayData[endPtr - 1] != 47) {
                            isRef.put(--elementCount - 1, "x");
                        } else {
                            ++elementCount;
                        }
                    }
                    lastCharIsSpace = charIsSpace;
                }
                if (!isRecursive && endPtr < arrayEnd && arrayData[endPtr] == 93 && this.type != 14) {
                    int ptr = endPtr - 1;
                    while (arrayData[ptr] == 13 || arrayData[ptr] == 10 || arrayData[ptr] == 32) {
                        --ptr;
                    }
                    if (arrayData[ptr] != 91) break;
                    elementCount = 0;
                    break;
                }
                ++endPtr;
            }
            if (elementCount == 0) {
                // empty if block
            }
        }
        if (ignoreRecursion && !alwaysRead) {
            return endPtr;
        }
        this.initObjectArray(elementCount);
        if (arrayData[j2] == 110 && arrayData[j2 + 1] == 117 && arrayData[j2 + 2] == 108 && arrayData[j2 + 3] == 108 && isSingleNull && (this.type != 22 || elementCount == 1)) {
            j2 += 3;
            if (this.type == 18) {
                this.mixedValues[currentElement] = null;
            } else if (this.type == 14) {
                this.keyValues[currentElement] = null;
            } else if (this.type == 20) {
                this.stringValues[currentElement] = null;
            } else if (this.type == 22) {
                this.objectValues[currentElement] = null;
            }
        } else {
            j2 = this.setValue(ignoreRecursion, raw, pdfObject, PDFkeyInt, isRef, isHexString, false, currentElement, elementCount, j2, arrayData, isSingleKey, endPtr);
        }
        if (!isIndirect) {
            this.i = j2;
        }
        if (this.type == 10) {
            pdfObject.setFloatArray(PDFkeyInt, this.floatValues);
        } else if (this.type == 9) {
            pdfObject.setIntArray(PDFkeyInt, this.intValues);
        } else if (this.type == 12) {
            pdfObject.setBooleanArray(PDFkeyInt, this.booleanValues);
        } else if (this.type == 16) {
            pdfObject.setDoubleArray(PDFkeyInt, this.doubleValues);
        } else if (this.type == 18) {
            pdfObject.setMixedArray(PDFkeyInt, this.mixedValues);
        } else if (this.type == 14) {
            this.setKeyArrayValue(pdfObject, PDFkeyInt, elementCount);
        } else if (this.type == 20) {
            pdfObject.setStringArray(PDFkeyInt, this.stringValues);
        } else if (this.type == 22) {
            this.setObjectArrayValue(pdfObject, PDFkeyInt, this.objectValuesArray, this.keyReached, false);
        }
        if (this.i < raw.length && (raw[this.i] == 47 || raw[this.i] == 62 || raw[this.i] >= 48 && raw[this.i] <= 57)) {
            --this.i;
        }
        return this.i;
    }

    private int setValue(boolean ignoreRecursion, byte[] raw, PdfObject pdfObject, int PDFkeyInt, Map ref, boolean hexString, boolean debugArray, int currentElement, int elementCount, int j2, byte[] arrayData, boolean singleKey, int endPtr) {
        while (arrayData[j2] != 93 && (endPtr <= -1 || j2 < endPtr)) {
            while (arrayData[j2] == 10 || arrayData[j2] == 13 || arrayData[j2] == 32 || arrayData[j2] == 47) {
                ++j2;
            }
            int keyStart = j2;
            if (debugArray) {
                System.out.print("j2=" + j2 + " value=" + (char)arrayData[j2]);
            }
            boolean isKey = arrayData[j2 - 1] == 47;
            boolean isRecursiveValue = false;
            if (this.type == 14 || (this.type == 18 || this.type == 22) && (ref.containsKey(currentElement) || PDFkeyInt == 1110717793 && arrayData[j2] >= 48 && arrayData[j2] <= 57 || arrayData[j2] == 60 && arrayData[j2 + 1] == 60)) {
                if (debugArray) {
                    System.out.println("ref currentElement=" + currentElement);
                }
                while (arrayData[j2] != 82 && arrayData[j2] != 93) {
                    if (arrayData[j2] == 60 && arrayData[j2 + 1] == 60) {
                        int levels = 1;
                        if (debugArray) {
                            System.out.println(padding + "Reading Direct value");
                        }
                        while (levels > 0) {
                            if (arrayData[++j2] == 60 && arrayData[j2 + 1] == 60) {
                                ++j2;
                                ++levels;
                                continue;
                            }
                            if (arrayData[j2] != 62 || arrayData[j2 + 1] != 62) continue;
                            ++j2;
                            --levels;
                        }
                        break;
                    }
                    if (isKey && PDFkeyInt == 9250 && arrayData[j2 + 1] == 32) break;
                    ++j2;
                }
                ++j2;
            } else if (arrayData[j2] == 40) {
                keyStart = j2 + 1;
                while (arrayData[j2] != 41 || ObjectUtils.isEscaped(arrayData, j2)) {
                    ++j2;
                }
                hexString = false;
            } else if (arrayData[j2] == 91 && this.type == 18 && PDFkeyInt == 826094945) {
                keyStart = j2;
                while (arrayData[j2] != 93) {
                    ++j2;
                }
                ++j2;
            } else if (arrayData[j2] == 60) {
                hexString = true;
                keyStart = j2 + 1;
                while (arrayData[j2] != 62) {
                    if (arrayData[j2] == 47) {
                        hexString = false;
                    }
                    ++j2;
                }
            } else if (arrayData[j2] == 91 && this.type == 22) {
                int len;
                int j3 = j2 + 1;
                int level = 1;
                while (++j3 != arrayData.length) {
                    if (arrayData[j3] == 93) {
                        --level;
                    } else if (arrayData[j3] == 91) {
                        ++level;
                    }
                    if (level != 0) continue;
                }
                ++j3;
                if (debugArray) {
                    padding = padding + "   ";
                }
                ArrayDecoder objDecoder = new ArrayDecoder(this.objectReader, j2, j3, this.type, this.objectValues, currentElement);
                j2 = objDecoder.readArray(ignoreRecursion, arrayData, pdfObject, PDFkeyInt);
                if (debugArray && (len = padding.length()) > 3) {
                    padding = padding.substring(0, len - 3);
                }
                if (arrayData[j2] != 91) {
                    ++j2;
                }
                isRecursiveValue = true;
                while (j2 < arrayData.length && arrayData[j2] == 93) {
                    ++j2;
                }
            } else if (!isKey && elementCount - currentElement == 1 && this.type == 18) {
                while (arrayData[j2] != 93 && arrayData[j2] != 47 && (arrayData[j2] != 62 || arrayData[j2 + 1] != 62)) {
                    ++j2;
                }
            } else {
                if (this.type == 22 && arrayData[j2] == 110 && arrayData[j2 + 1] == 117 && arrayData[j2 + 2] == 108 && arrayData[j2 + 3] == 108) {
                    j2 += 4;
                    this.objectValues[currentElement] = null;
                    ++currentElement;
                    continue;
                }
                while (arrayData[j2] != 10 && arrayData[j2] != 13 && arrayData[j2] != 32 && arrayData[j2] != 93 && arrayData[j2] != 47 && (arrayData[j2] != 62 || arrayData[j2 + 1] != 62) && ++j2 != arrayData.length) {
                }
            }
            if (this.type == 10) {
                this.floatValues[currentElement] = NumberUtils.parseFloat(keyStart, j2, arrayData);
            } else if (this.type == 9) {
                this.intValues[currentElement] = NumberUtils.parseInt(keyStart, j2, arrayData);
            } else if (this.type == 12) {
                if (raw[keyStart] == 116 && raw[keyStart + 1] == 114 && raw[keyStart + 2] == 117 && raw[keyStart + 3] == 101) {
                    this.booleanValues[currentElement] = true;
                }
            } else if (this.type == 16) {
                this.doubleValues[currentElement] = NumberUtils.parseFloat(keyStart, j2, arrayData);
            } else if (!isRecursiveValue) {
                j2 = this.setObjectArrayValue(pdfObject, PDFkeyInt, hexString, debugArray, currentElement, elementCount, j2, arrayData, singleKey, keyStart);
            }
            ++currentElement;
            if (debugArray) {
                System.out.println(padding + "roll onto ==================================>" + currentElement + '/' + elementCount);
            }
            if (currentElement != elementCount) continue;
            break;
        }
        return j2;
    }

    private int setObjectArrayValue(PdfObject pdfObject, int PDFkeyInt, boolean hexString, boolean debugArray, int currentElement, int elementCount, int j2, byte[] arrayData, boolean singleKey, int keyStart) {
        if (keyStart > 0 && arrayData[keyStart - 1] == 47) {
            --keyStart;
        }
        if (keyStart > 0 && arrayData[keyStart] == 91 && PDFkeyInt != 826094945) {
            ++keyStart;
        }
        if (PDFkeyInt == 1110717793 || PDFkeyInt == 826881374) {
            while (arrayData[keyStart] == 110 && arrayData[keyStart + 1] == 117 && arrayData[keyStart + 2] == 108 && arrayData[keyStart + 3] == 108) {
                keyStart += 4;
                while (keyStart >= 0 && (arrayData[keyStart] == 32 || arrayData[keyStart] == 10 || arrayData[keyStart] == 13 || arrayData[keyStart] == 9)) {
                    ++keyStart;
                }
            }
        }
        while (keyStart >= 0 && (arrayData[keyStart] == 32 || arrayData[keyStart] == 10 || arrayData[keyStart] == 13 || arrayData[keyStart] == 9)) {
            ++keyStart;
        }
        byte[] newValues = ObjectUtils.readEscapedValue(j2, arrayData, keyStart, PDFkeyInt == 6420);
        if (debugArray) {
            System.out.println(padding + "<1.Element -----" + currentElement + '/' + elementCount + "( j2=" + j2 + " ) value=" + new String(newValues) + '<');
        }
        if (j2 != arrayData.length) {
            if (arrayData[j2] == 62) {
                ++j2;
            } else if (arrayData[j2] == 41) {
                block27: {
                    ++j2;
                    try {
                        if (!pdfObject.isInCompressedStream() && this.decryption != null) {
                            newValues = this.decryption.decrypt(newValues, pdfObject.getObjectRefAsString(), false, null, false, false);
                        }
                    }
                    catch (PdfSecurityException e) {
                        if (!LogWriter.isOutput()) break block27;
                        LogWriter.writeLog("Exception: " + e.getMessage());
                    }
                }
                if (PDFkeyInt == 1110717793) {
                    newValues = StringUtils.toBytes(StringUtils.getTextString(newValues, false));
                }
            }
        }
        if (singleKey) {
            this.i = j2;
        }
        if (this.type == 18) {
            this.mixedValues[currentElement] = newValues;
        } else if (this.type == 14) {
            this.keyValues[currentElement] = ObjectUtils.convertReturnsToSpaces(newValues);
        } else if (this.type == 20) {
            if (hexString) {
                String str = new String(newValues);
                byte[] IDbytes = new byte[newValues.length / 2];
                for (int ii = 0; ii < newValues.length; ii += 2) {
                    if (ii + 2 > newValues.length) continue;
                    if (str.charAt(ii) == '\n') {
                        ++ii;
                    }
                    String nextValue = str.substring(ii, ii + 2);
                    IDbytes[ii / 2] = (byte)Integer.parseInt(nextValue, 16);
                }
                newValues = IDbytes;
            }
            this.stringValues[currentElement] = newValues;
        } else if (this.type == 22) {
            this.objectValues[currentElement] = newValues;
            if (debugArray) {
                System.out.println(padding + "objectValues[" + currentElement + "]=" + Arrays.toString(this.objectValues) + ' ');
            }
        }
        return j2;
    }

    private void initObjectArray(int elementCount) {
        if (this.type == 10) {
            this.floatValues = new float[elementCount];
        } else if (this.type == 9) {
            this.intValues = new int[elementCount];
        } else if (this.type == 12) {
            this.booleanValues = new boolean[elementCount];
        } else if (this.type == 16) {
            this.doubleValues = new double[elementCount];
        } else if (this.type == 18) {
            this.mixedValues = new byte[elementCount][];
        } else if (this.type == 14) {
            this.keyValues = new byte[elementCount][];
        } else if (this.type == 20) {
            this.stringValues = new byte[elementCount][];
        } else if (this.type == 22) {
            this.objectValues = new Object[elementCount];
        }
    }

    private boolean handleIndirect(int endPoint, byte[] raw, boolean debugArray) {
        boolean indirect = true;
        int aa = this.i;
        int length = raw.length;
        while (raw[aa] != 93 && ++aa < endPoint && aa < length && (raw[aa] != 82 || raw[aa - 1] != 32 && raw[aa - 1] != 10 && raw[aa - 1] != 13)) {
            if (raw[aa] == 62 && raw[aa - 1] == 62) {
                indirect = false;
                if (!debugArray) break;
                System.out.println(padding + "1. rejected as indirect ref");
                break;
            }
            if (raw[aa] != 47) continue;
            indirect = false;
            if (!debugArray) break;
            System.out.println(padding + "2. rejected as indirect ref - starts with /");
            break;
        }
        return indirect;
    }

    private void skipComment(byte[] raw) {
        while (raw[this.i] != 10 && raw[this.i] != 13) {
            ++this.i;
        }
        while (raw[this.i] == 10 || raw[this.i] == 13 || raw[this.i] == 32) {
            ++this.i;
        }
    }

    private void setKeyArrayValue(PdfObject pdfObject, int PDFkeyInt, int elementCount) {
        if (this.type == 14 && elementCount == 1 && PDFkeyInt == 1044338049) {
            PdfObject obj;
            byte[] newData;
            int size;
            byte[] objData = this.keyValues[0];
            if (objData != null && objData[(size = objData.length) - 1] == 82 && (newData = this.objectReader.readObjectData(obj = new PdfObject(new String(objData)))) != null) {
                int jj = 0;
                int newLen = newData.length;
                boolean hasArray = false;
                while (jj < newLen && ++jj != newData.length) {
                    if (newData[jj] == 91) {
                        hasArray = true;
                        break;
                    }
                    if (newData[jj - 1] != 60 || newData[jj] != 60) continue;
                    hasArray = false;
                    break;
                }
                if (hasArray) {
                    ArrayDecoder objDecoder = new ArrayDecoder(this.objectReader, jj, newLen, 14);
                    objDecoder.readArray(false, newData, pdfObject, PDFkeyInt);
                } else {
                    pdfObject.setKeyArray(PDFkeyInt, this.keyValues);
                }
            }
        } else {
            pdfObject.setKeyArray(PDFkeyInt, this.keyValues);
        }
    }

    private void setObjectArrayValue(PdfObject pdfObject, int PDFkeyInt, Object[] objectValuesArray, int keyReached, boolean debugArray) {
        int size;
        byte[] objData;
        if (PDFkeyInt == 1110717793 && this.objectValues != null && this.objectValues.length == 1 && this.objectValues[0] instanceof byte[] && (objData = (byte[])this.objectValues[0])[(size = objData.length) - 1] == 82) {
            OCObject obj = new OCObject(new String(objData));
            byte[] newData = this.objectReader.readObjectData(obj);
            int jj = 0;
            int newLen = newData.length;
            boolean hasArray = false;
            while (jj < newLen && ++jj != newData.length) {
                if (newData[jj] != 91) continue;
                hasArray = true;
                break;
            }
            if (hasArray) {
                ArrayDecoder objDecoder = new ArrayDecoder(this.objectReader, jj, newLen, 22);
                objDecoder.readArray(false, newData, pdfObject, PDFkeyInt);
            }
            this.objectValues = null;
        }
        if (objectValuesArray != null) {
            objectValuesArray[keyReached] = this.objectValues;
            if (debugArray) {
                System.out.println(padding + "set Object objectValuesArray[" + keyReached + "]=" + Arrays.toString(this.objectValues));
            }
        } else if (this.objectValues != null) {
            pdfObject.setObjectArray(PDFkeyInt, this.objectValues);
            if (debugArray) {
                System.out.println(padding + PDFkeyInt + " set Object value=" + Arrays.toString(this.objectValues));
            }
        }
    }

    private void showValues() {
        String values = "[";
        if (this.type == 10) {
            for (float floatValue : this.floatValues) {
                values = values + floatValue + ' ';
            }
        } else if (this.type == 16) {
            for (double doubleValue : this.doubleValues) {
                values = values + doubleValue + ' ';
            }
        } else if (this.type == 9) {
            for (int intValue : this.intValues) {
                values = values + intValue + ' ';
            }
        } else if (this.type == 12) {
            for (boolean booleanValue : this.booleanValues) {
                values = values + booleanValue + ' ';
            }
        } else if (this.type == 18) {
            for (byte[] mixedValue : this.mixedValues) {
                values = mixedValue == null ? values + "null " : values + new String(mixedValue) + ' ';
            }
        } else if (this.type == 14) {
            for (byte[] keyValue : this.keyValues) {
                values = keyValue == null ? values + "null " : values + new String(keyValue) + ' ';
            }
        } else if (this.type == 20) {
            for (byte[] stringValue : this.stringValues) {
                values = stringValue == null ? values + "null " : values + new String(stringValue) + ' ';
            }
        } else if (this.type == 22) {
            values = ObjectUtils.showMixedValuesAsString(this.objectValues, "");
        }
        values = values + " ]";
        System.out.println(padding + "values=" + values);
    }
}

