/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.jpedal.utils.LogWriter;

public class CertificateReader {
    public static byte[] readCertificate(byte[][] recipients, Certificate certificate, Key key) {
        byte[] envelopedData = null;
        String provider = "BC";
        for (byte[] recipient : recipients) {
            try {
                CMSEnvelopedData recipientEnvelope = new CMSEnvelopedData(recipient);
                Object[] recipientList = recipientEnvelope.getRecipientInfos().getRecipients().toArray();
                int listCount = recipientList.length;
                for (int ii = 0; ii < listCount; ++ii) {
                    RecipientInformation recipientInfo = (RecipientInformation)recipientList[ii];
                    if (!recipientInfo.getRID().match(certificate)) continue;
                    envelopedData = recipientInfo.getContent(new JceKeyTransEnvelopedRecipient((PrivateKey)key).setProvider(provider));
                    ii = listCount;
                }
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) continue;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        return envelopedData;
    }
}

