/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import org.jpedal.exception.PdfSecurityException;
import org.jpedal.io.ArrayDecoder;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.ObjectUtils;
import org.jpedal.io.PdfFileReader;
import org.jpedal.objects.raw.ColorSpaceObject;
import org.jpedal.objects.raw.FunctionObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.NumberUtils;

public class ColorObjectDecoder
extends ObjectDecoder {
    private static final long serialVersionUID = -5485453047644686880L;
    private static final boolean debugColorspace = false;

    public ColorObjectDecoder(PdfFileReader objectReader) {
        super(objectReader);
    }

    int handleColorSpaces(PdfObject pdfObject, int i, byte[] raw) {
        int len = raw.length;
        while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 91 || raw[i] == 93) {
            if (raw[i] == 91) {
                pdfObject.maybeIndirect(true);
            }
            ++i;
        }
        if (raw[i] == 47) {
            int constant;
            ++i;
            while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 47) {
                ++i;
            }
            int keyStart = i;
            int keyLength = 0;
            while (raw[i] != 10 && raw[i] != 13 && raw[i] != 32 && raw[i] != 47 && raw[i] != 60 && raw[i] != 62 && raw[i] != 91 && raw[i] != 93) {
                ++keyLength;
                if (++i != len) continue;
            }
            if ((constant = pdfObject.setConstant(2087749783, keyStart, keyLength, raw)) == 25) {
                constant = 895578984;
            }
            i = this.setColorspace(pdfObject, i, raw, constant);
        } else if (raw[i] == 60 && raw[i + 1] == 60) {
            i = this.readObjectValue(pdfObject, i, raw);
        } else if (raw[i] == 37) {
            while (raw[i] != 10 && raw[i] != 13) {
                ++i;
            }
        } else {
            i = raw[i] == 60 ? this.readHexValue(pdfObject, i, raw) : (raw[i] == 40 ? this.readStringValue(pdfObject, i, raw) : this.readColorObjectValue(pdfObject, i, raw));
        }
        if (i < len && (raw[i] == 47 || raw[i] == 62)) {
            --i;
        }
        return i;
    }

    private int setColorspace(PdfObject pdfObject, int i, byte[] raw, int constant) {
        switch (constant) {
            case 1008872003: {
                i = this.handleColorSpaces(pdfObject, i, raw);
                ++i;
                break;
            }
            case 391471749: {
                i = this.handleColorSpaces(pdfObject, i, raw);
                ++i;
                break;
            }
            case 1498837125: {
                break;
            }
            case 1568372915: {
                break;
            }
            case 960981604: {
                i = this.readDeviceNvalue(pdfObject, i, raw);
                break;
            }
            case 1785221209: {
                break;
            }
            case 1247168582: {
                i = this.readDictionaryFromRefOrDirect(-1, pdfObject, "", i, raw, 2087749783);
                break;
            }
            case 895578984: {
                i = this.readIndexedColorspace(pdfObject, i, raw);
                break;
            }
            case 1847602: {
                i = this.handleColorSpaces(pdfObject, i, raw);
                ++i;
                break;
            }
            case 1146450818: {
                break;
            }
            case -2073385820: {
                i = this.readSeparationColorspace(pdfObject, i, raw);
            }
        }
        return i;
    }

    private int readDeviceNvalue(PdfObject pdfObject, int i, byte[] raw) {
        int endPoint;
        for (endPoint = i; endPoint < raw.length && raw[endPoint] != 93; ++endPoint) {
        }
        ArrayDecoder objDecoder = new ArrayDecoder(this.objectReader, i, endPoint, 20);
        i = objDecoder.readArray(false, raw, pdfObject, 1920898752);
        while (raw[i] == 93 || raw[i] == 32 || raw[i] == 10 || raw[i] == 13) {
            ++i;
        }
        ColorSpaceObject altColorSpace = new ColorSpaceObject(-1, 0);
        i = this.handleColorSpaces(altColorSpace, i, raw);
        pdfObject.setDictionary(-1247101998, altColorSpace);
        ++i;
        FunctionObject tintTransform = new FunctionObject(-1, 0);
        i = this.handleColorSpaces(tintTransform, i, raw);
        pdfObject.setDictionary(-1313946392, tintTransform);
        for (int ii = i; ii < raw.length && raw[ii] != 93; ++ii) {
            if (raw[ii] == 32 || raw[ii] == 10 || raw[ii] == 13) continue;
            i = ii;
            ColorSpaceObject attributesObj = new ColorSpaceObject(-1, 0);
            i = this.handleColorSpaces(attributesObj, i, raw);
            pdfObject.setDictionary(861242754, attributesObj);
            --i;
            ii = raw.length;
        }
        return ++i;
    }

    private int readColorObjectValue(PdfObject pdfObject, int i, byte[] raw) {
        byte[] data;
        int keyStart2 = i;
        while (raw[i] != 10 && raw[i] != 13 && raw[i] != 32 && raw[i] != 47 && raw[i] != 60 && raw[i] != 62 && raw[i] != 93) {
            ++i;
        }
        int number = NumberUtils.parseInt(keyStart2, i, raw);
        while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 47 || raw[i] == 60) {
            ++i;
        }
        keyStart2 = i;
        while (raw[i] != 10 && raw[i] != 13 && raw[i] != 32 && raw[i] != 47 && raw[i] != 60 && raw[i] != 62) {
            ++i;
        }
        int generation = NumberUtils.parseInt(keyStart2, i, raw);
        while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 47 || raw[i] == 60) {
            ++i;
        }
        if (raw[i] != 82) {
            throw new RuntimeException("3. Unexpected value in file " + (char)raw[i] + " - please send to IDRsolutions for analysis");
        }
        ++i;
        if (pdfObject.getObjectRefID() == -1 || pdfObject.maybeIndirect()) {
            pdfObject.setRef(number, generation);
        }
        if ((data = this.objectReader.readObjectAsByteArray(pdfObject, this.objectReader.isCompressed(number, generation), number, generation)) == null) {
            pdfObject.setFullyResolved(false);
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("[Linearized] " + number + ' ' + generation + " R not yet available (9)");
            }
            i = raw.length;
        } else if (data[0] == 47) {
            this.handleColorSpaces(pdfObject, 0, data);
        } else {
            int j = 0;
            if (data[0] != 91 && data[0] != 60) {
                j = 3;
                while (data[j - 1] != 106 && data[j - 2] != 98 && data[j - 3] != 111) {
                    ++j;
                }
            }
            this.handleColorSpaces(pdfObject, j, data);
        }
        return i;
    }

    private int readIndexedColorspace(PdfObject pdfObject, int i, byte[] raw) {
        ColorSpaceObject IndexedColorSpace = new ColorSpaceObject(-1, 0, true);
        pdfObject.setDictionary(895578984, IndexedColorSpace);
        for (i = this.handleColorSpaces(IndexedColorSpace, i, raw); i < raw.length && (raw[i] == 32 || raw[i] == 13 || raw[i] == 10 || raw[i] == 93 || raw[i] == 62); ++i) {
        }
        if (raw[i = this.setNumberValue(pdfObject, i, raw, 960901492)] != 40) {
            ++i;
        }
        while (i < raw.length && (raw[i] == 32 || raw[i] == 13 || raw[i] == 10)) {
            ++i;
        }
        boolean needsKey = raw[i] == 91 || raw[i] == 40 || raw[i] == 60;
        ColorSpaceObject IndexedColorSpaceData = needsKey ? new ColorSpaceObject(pdfObject.getObjectRefAsString()) : new ColorSpaceObject(-1, 0);
        pdfObject.setDictionary(1060856191, IndexedColorSpaceData);
        i = this.handleColorSpaces(IndexedColorSpaceData, i, raw);
        return ++i;
    }

    private int readSeparationColorspace(PdfObject pdfObject, int i, byte[] raw) {
        int endPoint = i;
        while (raw[endPoint] == 47 || raw[endPoint] == 32 || raw[endPoint] == 10 || raw[endPoint] == 13) {
            ++endPoint;
        }
        int startPt = endPoint;
        while (endPoint < raw.length && raw[endPoint] != 47 && raw[endPoint] != 32 && raw[endPoint] != 13 && raw[endPoint] != 10) {
            ++endPoint;
        }
        int keyLength = endPoint - startPt;
        byte[] stringBytes = new byte[keyLength];
        System.arraycopy(raw, startPt, stringBytes, 0, keyLength);
        pdfObject.setName(506543413, stringBytes);
        i = endPoint;
        if (raw[i] != 47) {
            ++i;
        }
        ColorSpaceObject altColorSpace = new ColorSpaceObject(-1, 0);
        i = this.handleColorSpaces(altColorSpace, i, raw);
        pdfObject.setDictionary(-1247101998, altColorSpace);
        if (raw[i] != 60) {
            ++i;
        }
        FunctionObject tintTransform = new FunctionObject(-1, 0);
        i = this.handleColorSpaces(tintTransform, i, raw);
        pdfObject.setDictionary(-1313946392, tintTransform);
        return ++i;
    }

    private int readObjectValue(PdfObject pdfObject, int i, byte[] raw) {
        i = this.convertDirectDictionaryToObject(pdfObject, "", i, raw, -1);
        if (pdfObject.hasStream()) {
            int count = raw.length;
            int ends = 0;
            for (int xx = i; xx < count - 5; ++xx) {
                if (raw[xx] == 62 && raw[xx + 1] == 62) {
                    ++ends;
                }
                if (ends == 2) break;
                if (raw[xx] != 115 || raw[xx + 1] != 116 || raw[xx + 2] != 114 || raw[xx + 3] != 101 || raw[xx + 4] != 97 || raw[xx + 5] != 109) continue;
                this.readStreamIntoObject(pdfObject, xx, raw);
                xx = count;
            }
        }
        return i;
    }

    private int readHexValue(PdfObject pdfObject, int i, byte[] raw) {
        byte[] stream;
        block20: {
            int end = ++i;
            int validCharCount = 0;
            while (raw[end] != 62) {
                if (raw[end] != 32 && raw[end] != 10 && raw[end] != 13) {
                    ++validCharCount;
                }
                ++end;
            }
            int byteCount = validCharCount >> 1;
            stream = new byte[byteCount];
            int byteReached = 0;
            while (true) {
                if (raw[i] == 32 || raw[i] == 10 || raw[i] == 13) {
                    ++i;
                    continue;
                }
                int topHex = raw[i];
                if (topHex >= 65 && topHex <= 70) {
                    topHex -= 55;
                } else if (topHex >= 97 && topHex <= 102) {
                    topHex -= 87;
                } else if (topHex >= 48 && topHex <= 57) {
                    topHex -= 48;
                } else {
                    throw new RuntimeException("Unexpected number " + (char)raw[i]);
                }
                ++i;
                while (raw[i] == 32 || raw[i] == 10 || raw[i] == 13) {
                    ++i;
                }
                int bottomHex = raw[i];
                if (bottomHex >= 65 && bottomHex <= 70) {
                    bottomHex -= 55;
                } else if (bottomHex >= 97 && bottomHex <= 102) {
                    bottomHex -= 87;
                } else if (bottomHex >= 48 && bottomHex <= 57) {
                    bottomHex -= 48;
                } else {
                    throw new RuntimeException("Unexpected number " + (char)raw[i]);
                }
                ++i;
                int finalValue = bottomHex + (topHex << 4);
                stream[byteReached] = (byte)finalValue;
                if (++byteReached == byteCount) break;
            }
            try {
                if (this.decryption != null) {
                    stream = this.decryption.decrypt(stream, pdfObject.getObjectRefAsString(), false, null, false, false);
                }
            }
            catch (PdfSecurityException e) {
                if (!LogWriter.isOutput()) break block20;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        pdfObject.setDecodedStream(stream);
        return i;
    }

    private int readStringValue(PdfObject pdfObject, int i, byte[] raw) {
        byte[] nRaw;
        block4: {
            int start = ++i;
            while (raw[i] != 41 || ObjectUtils.isEscaped(raw, i) && raw[i - 1] != 0) {
                ++i;
            }
            nRaw = ObjectUtils.readEscapedValue(i, raw, start, false);
            try {
                if (this.decryption != null) {
                    nRaw = this.decryption.decrypt(nRaw, pdfObject.getObjectRefAsString(), false, null, false, false);
                }
            }
            catch (PdfSecurityException e) {
                if (!LogWriter.isOutput()) break block4;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        pdfObject.setDecodedStream(nRaw);
        return i;
    }

    private static void showData(PdfObject pdfObject, byte[] raw, int i) {
        System.out.println(padding + "Reading colorspace into " + pdfObject + " ref=" + pdfObject.getObjectRefAsString() + " i=" + i + " chars=" + (char)raw[i] + (char)raw[i + 1] + (char)raw[i + 2] + (char)raw[i + 3] + (char)raw[i + 4]);
        System.out.println(padding + "------------>");
        for (int ii = i; ii < raw.length; ++ii) {
            System.out.print((char)raw[ii]);
            if (ii <= 5 || raw[ii - 5] != 115 || raw[ii - 4] != 116 || raw[ii - 3] != 114 || raw[ii - 2] != 101 || raw[ii - 1] != 97 || raw[ii] != 109) continue;
            ii = raw.length;
        }
        System.out.println("<--------");
    }

    int processColorSpace(PdfObject pdfObject, String objectRef, int i, byte[] raw) {
        if (!pdfObject.ignoreRecursion()) {
            if (pdfObject.getObjectType() == 2087749783) {
                return this.handleColorSpaces(pdfObject, i, raw);
            }
            boolean isKey = raw[i] == 47;
            ColorSpaceObject ColorSpace2 = isKey ? new ColorSpaceObject(objectRef) : new ColorSpaceObject(-1, 0);
            pdfObject.setDictionary(2087749783, ColorSpace2);
            if (ColorSpace2.isDataExternal()) {
                ColorSpace2.isDataExternal(true);
                if (!this.resolveFully(ColorSpace2)) {
                    pdfObject.setFullyResolved(false);
                }
            }
            return this.handleColorSpaces(ColorSpace2, i, raw);
        }
        return i;
    }
}

