/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.filter;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.util.Map;
import org.jpedal.io.filter.BaseFilter;
import org.jpedal.io.filter.PdfFilter;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class ASCII85
extends BaseFilter
implements PdfFilter {
    private static final long[] hex_indices = new long[]{0x1000000L, 65536L, 256L, 1L};
    private static final long[] base_85_indices = new long[]{52200625L, 614125L, 7225L, 85L, 1L};

    public ASCII85(PdfObject decodeParms) {
        super(decodeParms);
    }

    @Override
    public byte[] decode(byte[] valuesRead) {
        int special_cases = 0;
        int returns = 0;
        int data_size = valuesRead.length;
        for (int i = 0; i < data_size; ++i) {
            if (valuesRead[i] == 122) {
                ++special_cases;
                continue;
            }
            if (valuesRead[i] != 10) continue;
            ++returns;
        }
        if (returns == 5 && special_cases == 0 && (data_size - returns) % 5 == 4) {
            ++data_size;
        }
        int output_pointer = 0;
        byte[] temp_data = new byte[data_size - returns + 1 + special_cases * 3];
        for (int i = 0; i < data_size; ++i) {
            int i3;
            long value = 0L;
            byte next = valuesRead[i];
            while (next == 10 || next == 13) {
                if (++i == data_size) {
                    next = 0;
                    continue;
                }
                next = valuesRead[i];
            }
            if (next == 122) {
                for (i3 = 0; i3 < 4; ++i3) {
                    temp_data[output_pointer] = 0;
                    ++output_pointer;
                }
                continue;
            }
            if (data_size - i <= 4 || next <= 32 || next >= 118) continue;
            for (int ii = 0; ii < 5; ++ii) {
                if (i < valuesRead.length) {
                    next = valuesRead[i];
                }
                while (next == 10 || next == 13) {
                    if (++i == data_size) {
                        next = 0;
                        continue;
                    }
                    next = valuesRead[i];
                }
                ++i;
                if ((next <= 32 || next >= 118) && next != 126) continue;
                value += (long)(next - 33) * base_85_indices[ii];
            }
            for (i3 = 0; i3 < 4; ++i3) {
                temp_data[output_pointer] = (byte)(value / hex_indices[i3] & 0xFFL);
                ++output_pointer;
            }
            --i;
        }
        byte[] processed_data = new byte[output_pointer];
        System.arraycopy(temp_data, 0, processed_data, 0, output_pointer);
        return processed_data;
    }

    @Override
    public void decode(BufferedInputStream bis, BufferedOutputStream streamCache, String cacheName, Map cachedObjects) {
        block9: {
            this.bis = bis;
            this.streamCache = streamCache;
            this.cachedObjects = cachedObjects;
            try {
                boolean ignoreLastItem = false;
                while (bis.available() > 0) {
                    int i3;
                    long value = 0L;
                    int nextValue = ASCII85.read(bis);
                    if (nextValue == 122) {
                        for (i3 = 0; i3 < 4; ++i3) {
                            streamCache.write(0);
                        }
                        continue;
                    }
                    if (bis.available() < 4 || nextValue <= 32 || nextValue >= 118) continue;
                    value += (long)(nextValue - 33) * base_85_indices[0];
                    for (int ii = 1; ii < 5; ++ii) {
                        nextValue = ASCII85.read(bis);
                        if (nextValue == -1) {
                            nextValue = 0;
                        }
                        if (nextValue == -1) {
                            ignoreLastItem = true;
                        }
                        if ((nextValue <= 32 || nextValue >= 118) && nextValue != 126) continue;
                        value += (long)(nextValue - 33) * base_85_indices[ii];
                    }
                    if (ignoreLastItem) continue;
                    for (i3 = 0; i3 < 4; ++i3) {
                        byte b = (byte)(value / hex_indices[i3] & 0xFFL);
                        streamCache.write(b);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!LogWriter.isOutput()) break block9;
                LogWriter.writeLog("Exception " + e + " accessing Ascii85Decode filter ");
            }
        }
    }

    private static int read(BufferedInputStream bis) throws IOException {
        int nextValue = bis.read();
        while (nextValue == 13 || nextValue == 10) {
            nextValue = bis.read();
        }
        return nextValue;
    }
}

