/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.jbig2.decoders;

import java.io.IOException;
import org.jpedal.jbig2.decoders.ArithmeticDecoderStats;
import org.jpedal.jbig2.decoders.DecodeIntResult;
import org.jpedal.jbig2.io.StreamReader;
import org.jpedal.jbig2.util.BinaryOperation;

public class ArithmeticDecoder {
    private StreamReader reader;
    public ArithmeticDecoderStats genericRegionStats;
    public ArithmeticDecoderStats refinementRegionStats;
    public ArithmeticDecoderStats iadhStats;
    public ArithmeticDecoderStats iadwStats;
    public ArithmeticDecoderStats iaexStats;
    public ArithmeticDecoderStats iaaiStats;
    public ArithmeticDecoderStats iadtStats;
    public ArithmeticDecoderStats iaitStats;
    public ArithmeticDecoderStats iafsStats;
    public ArithmeticDecoderStats iadsStats;
    public ArithmeticDecoderStats iardxStats;
    public ArithmeticDecoderStats iardyStats;
    public ArithmeticDecoderStats iardwStats;
    public ArithmeticDecoderStats iardhStats;
    public ArithmeticDecoderStats iariStats;
    public ArithmeticDecoderStats iaidStats;
    int[] contextSize = new int[]{16, 13, 10, 10};
    int[] referredToContextSize = new int[]{13, 10};
    long buffer0;
    long buffer1;
    long c;
    long a;
    long previous;
    int counter;
    int[] qeTable = new int[]{1442906112, 872480768, 0x18010000, 180420608, 86048768, 0x2210000, 1442906112, 1409351680, 1208025088, 939589632, 0x30010000, 604045312, 0x1C010000, 0x16010000, 1442906112, 1409351680, 0x51010000, 1208025088, 939589632, 872480768, 0x30010000, 671154176, 604045312, 0x22010000, 0x1C010000, 0x18010000, 0x16010000, 0x14010000, 0x12010000, 0x11010000, 180420608, 163643392, 144769024, 86048768, 0x4410000, 44105728, 0x2210000, 0x1410000, 0x1110000, 0x850000, 0x490000, 0x250000, 0x150000, 589824, 327680, 65536, 1442906112};
    int[] nmpsTable = new int[]{1, 2, 3, 4, 5, 38, 7, 8, 9, 10, 11, 12, 13, 29, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 45, 46};
    int[] nlpsTable = new int[]{1, 6, 9, 12, 29, 33, 6, 14, 14, 14, 17, 18, 20, 21, 14, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 46};
    int[] switchTable = new int[]{1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    private ArithmeticDecoder() {
    }

    public ArithmeticDecoder(StreamReader reader) {
        this.reader = reader;
        this.genericRegionStats = new ArithmeticDecoderStats(2);
        this.refinementRegionStats = new ArithmeticDecoderStats(2);
        this.iadhStats = new ArithmeticDecoderStats(512);
        this.iadwStats = new ArithmeticDecoderStats(512);
        this.iaexStats = new ArithmeticDecoderStats(512);
        this.iaaiStats = new ArithmeticDecoderStats(512);
        this.iadtStats = new ArithmeticDecoderStats(512);
        this.iaitStats = new ArithmeticDecoderStats(512);
        this.iafsStats = new ArithmeticDecoderStats(512);
        this.iadsStats = new ArithmeticDecoderStats(512);
        this.iardxStats = new ArithmeticDecoderStats(512);
        this.iardyStats = new ArithmeticDecoderStats(512);
        this.iardwStats = new ArithmeticDecoderStats(512);
        this.iardhStats = new ArithmeticDecoderStats(512);
        this.iariStats = new ArithmeticDecoderStats(512);
        this.iaidStats = new ArithmeticDecoderStats(2);
    }

    public void resetIntStats(int symbolCodeLength) {
        this.iadhStats.reset();
        this.iadwStats.reset();
        this.iaexStats.reset();
        this.iaaiStats.reset();
        this.iadtStats.reset();
        this.iaitStats.reset();
        this.iafsStats.reset();
        this.iadsStats.reset();
        this.iardxStats.reset();
        this.iardyStats.reset();
        this.iardwStats.reset();
        this.iardhStats.reset();
        this.iariStats.reset();
        if (this.iaidStats.getContextSize() == 1 << symbolCodeLength + 1) {
            this.iaidStats.reset();
        } else {
            this.iaidStats = new ArithmeticDecoderStats(1 << symbolCodeLength + 1);
        }
    }

    public void resetGenericStats(int template, ArithmeticDecoderStats previousStats) {
        int size = this.contextSize[template];
        if (previousStats != null && previousStats.getContextSize() == size) {
            if (this.genericRegionStats.getContextSize() == size) {
                this.genericRegionStats.overwrite(previousStats);
            } else {
                this.genericRegionStats = previousStats.copy();
            }
        } else if (this.genericRegionStats.getContextSize() == size) {
            this.genericRegionStats.reset();
        } else {
            this.genericRegionStats = new ArithmeticDecoderStats(1 << size);
        }
    }

    public void resetRefinementStats(int template, ArithmeticDecoderStats previousStats) {
        int size = this.referredToContextSize[template];
        if (previousStats != null && previousStats.getContextSize() == size) {
            if (this.refinementRegionStats.getContextSize() == size) {
                this.refinementRegionStats.overwrite(previousStats);
            } else {
                this.refinementRegionStats = previousStats.copy();
            }
        } else if (this.refinementRegionStats.getContextSize() == size) {
            this.refinementRegionStats.reset();
        } else {
            this.refinementRegionStats = new ArithmeticDecoderStats(1 << size);
        }
    }

    public void start() throws IOException {
        this.buffer0 = this.reader.readByte();
        this.buffer1 = this.reader.readByte();
        this.c = BinaryOperation.bit32ShiftL(this.buffer0 ^ 0xFFL, 16);
        this.readByte();
        this.c = BinaryOperation.bit32ShiftL(this.c, 7);
        this.counter -= 7;
        this.a = 0x80000000L;
    }

    public DecodeIntResult decodeInt(ArithmeticDecoderStats stats) throws IOException {
        int decodedInt;
        long value;
        this.previous = 1L;
        int s = this.decodeIntBit(stats);
        if (this.decodeIntBit(stats) != 0) {
            if (this.decodeIntBit(stats) != 0) {
                int i;
                if (this.decodeIntBit(stats) != 0) {
                    if (this.decodeIntBit(stats) != 0) {
                        if (this.decodeIntBit(stats) != 0) {
                            value = 0L;
                            for (i = 0; i < 32; ++i) {
                                value = BinaryOperation.bit32ShiftL(value, 1) | (long)this.decodeIntBit(stats);
                            }
                            value += 4436L;
                        } else {
                            value = 0L;
                            for (i = 0; i < 12; ++i) {
                                value = BinaryOperation.bit32ShiftL(value, 1) | (long)this.decodeIntBit(stats);
                            }
                            value += 340L;
                        }
                    } else {
                        value = 0L;
                        for (i = 0; i < 8; ++i) {
                            value = BinaryOperation.bit32ShiftL(value, 1) | (long)this.decodeIntBit(stats);
                        }
                        value += 84L;
                    }
                } else {
                    value = 0L;
                    for (i = 0; i < 6; ++i) {
                        value = BinaryOperation.bit32ShiftL(value, 1) | (long)this.decodeIntBit(stats);
                    }
                    value += 20L;
                }
            } else {
                value = this.decodeIntBit(stats);
                value = BinaryOperation.bit32ShiftL(value, 1) | (long)this.decodeIntBit(stats);
                value = BinaryOperation.bit32ShiftL(value, 1) | (long)this.decodeIntBit(stats);
                value = BinaryOperation.bit32ShiftL(value, 1) | (long)this.decodeIntBit(stats);
                value += 4L;
            }
        } else {
            value = this.decodeIntBit(stats);
            value = BinaryOperation.bit32ShiftL(value, 1) | (long)this.decodeIntBit(stats);
        }
        if (s != 0) {
            if (value == 0L) {
                return new DecodeIntResult((int)value, false);
            }
            decodedInt = (int)(-value);
        } else {
            decodedInt = (int)value;
        }
        return new DecodeIntResult(decodedInt, true);
    }

    public long decodeIAID(long codeLen, ArithmeticDecoderStats stats) throws IOException {
        this.previous = 1L;
        for (long i = 0L; i < codeLen; ++i) {
            int bit = this.decodeBit(this.previous, stats);
            this.previous = BinaryOperation.bit32ShiftL(this.previous, 1) | (long)bit;
        }
        return this.previous - (long)(1 << (int)codeLen);
    }

    public int decodeBit(long context, ArithmeticDecoderStats stats) throws IOException {
        int bit;
        int iCX = BinaryOperation.bit8Shift(stats.getContextCodingTableValue((int)context), 1, 1);
        int mpsCX = stats.getContextCodingTableValue((int)context) & 1;
        int qe = this.qeTable[iCX];
        this.a -= (long)qe;
        if (this.c < this.a) {
            if ((this.a & Integer.MIN_VALUE) != 0L) {
                bit = mpsCX;
            } else {
                if (this.a < (long)qe) {
                    bit = 1 - mpsCX;
                    if (this.switchTable[iCX] != 0) {
                        stats.setContextCodingTableValue((int)context, this.nlpsTable[iCX] << 1 | 1 - mpsCX);
                    } else {
                        stats.setContextCodingTableValue((int)context, this.nlpsTable[iCX] << 1 | mpsCX);
                    }
                } else {
                    bit = mpsCX;
                    stats.setContextCodingTableValue((int)context, this.nmpsTable[iCX] << 1 | mpsCX);
                }
                do {
                    if (this.counter == 0) {
                        this.readByte();
                    }
                    this.a = BinaryOperation.bit32ShiftL(this.a, 1);
                    this.c = BinaryOperation.bit32ShiftL(this.c, 1);
                    --this.counter;
                } while ((this.a & Integer.MIN_VALUE) == 0L);
            }
        } else {
            this.c -= this.a;
            if (this.a < (long)qe) {
                bit = mpsCX;
                stats.setContextCodingTableValue((int)context, this.nmpsTable[iCX] << 1 | mpsCX);
            } else {
                bit = 1 - mpsCX;
                if (this.switchTable[iCX] != 0) {
                    stats.setContextCodingTableValue((int)context, this.nlpsTable[iCX] << 1 | 1 - mpsCX);
                } else {
                    stats.setContextCodingTableValue((int)context, this.nlpsTable[iCX] << 1 | mpsCX);
                }
            }
            this.a = qe;
            do {
                if (this.counter == 0) {
                    this.readByte();
                }
                this.a = BinaryOperation.bit32ShiftL(this.a, 1);
                this.c = BinaryOperation.bit32ShiftL(this.c, 1);
                --this.counter;
            } while ((this.a & Integer.MIN_VALUE) == 0L);
        }
        return bit;
    }

    private void readByte() throws IOException {
        if (this.buffer0 == 255L) {
            if (this.buffer1 > 143L) {
                this.counter = 8;
            } else {
                this.buffer0 = this.buffer1;
                this.buffer1 = this.reader.readByte();
                this.c = this.c + 65024L - BinaryOperation.bit32ShiftL(this.buffer0, 9);
                this.counter = 7;
            }
        } else {
            this.buffer0 = this.buffer1;
            this.buffer1 = this.reader.readByte();
            this.c = this.c + 65280L - BinaryOperation.bit32ShiftL(this.buffer0, 8);
            this.counter = 8;
        }
    }

    private int decodeIntBit(ArithmeticDecoderStats stats) throws IOException {
        int bit = this.decodeBit(this.previous, stats);
        this.previous = this.previous < 256L ? BinaryOperation.bit32ShiftL(this.previous, 1) | (long)bit : (BinaryOperation.bit32ShiftL(this.previous, 1) | (long)bit) & 0x1FFL | 0x100L;
        return bit;
    }
}

