/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.creation;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jpedal.color.DeviceCMYKColorSpace;
import org.jpedal.objects.acroforms.actions.ActionFactory;
import org.jpedal.objects.acroforms.actions.ActionHandler;
import org.jpedal.objects.acroforms.actions.SwingActionFactory;
import org.jpedal.objects.acroforms.actions.SwingListener;
import org.jpedal.objects.acroforms.creation.FormFactory;
import org.jpedal.objects.acroforms.creation.GenericFormFactory;
import org.jpedal.objects.acroforms.formData.GUIData;
import org.jpedal.objects.acroforms.formData.SwingData;
import org.jpedal.objects.acroforms.overridingImplementations.FixImageIcon;
import org.jpedal.objects.acroforms.rendering.AcroRenderer;
import org.jpedal.objects.acroforms.utils.ConvertToString;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.utils.LogWriter;

public class SwingFormFactory
extends GenericFormFactory
implements FormFactory {
    private AcroRenderer acrorend;
    private boolean printAllouts;
    private boolean printouts;

    public SwingFormFactory(AcroRenderer acroRenderer, ActionHandler actionHandler) {
        this.printouts = this.printAllouts = false;
        this.acrorend = acroRenderer;
        this.formsActionHandler = actionHandler;
    }

    @Override
    public void reset(AcroRenderer acroRenderer, ActionHandler actionHandler) {
        this.acrorend = acroRenderer;
        this.formsActionHandler = actionHandler;
    }

    @Override
    public Object annotationButton(FormObject form) {
        JButton but = new JButton();
        this.setupButton(but, form);
        this.setupUniversalFeatures(but, form);
        int subtype = form.getParameterConstant(1147962727);
        boolean newAnnots = true;
        switch (subtype) {
            case 607471684: {
                String name = form.getTextStreamValue(506543413);
                if (name == null || !name.equals("Comment")) break;
                try {
                    BufferedImage commentIcon = ImageIO.read(this.getClass().getResource("/org/jpedal/objects/acroforms/res/comment.png"));
                    but.setIcon(new FixImageIcon(commentIcon, 0));
                }
                catch (Exception e) {
                    if (!LogWriter.isOutput()) break;
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
                break;
            }
            case 1919840408: {
                float[] quad;
                if (!newAnnots) break;
                float[] f = form.getFloatArray(19);
                Color c = new Color(0);
                if (f != null) {
                    switch (f.length) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            c = new Color(f[0], f[0], f[0], 0.5f);
                            break;
                        }
                        case 3: {
                            c = new Color(f[0], f[1], f[2], 0.5f);
                            break;
                        }
                        case 4: {
                            DeviceCMYKColorSpace cmyk = new DeviceCMYKColorSpace();
                            cmyk.setColor(f, 4);
                            c = new Color(cmyk.getColor().getRGB());
                            c = new Color((float)c.getRed(), (float)c.getGreen(), (float)c.getBlue(), 0.5f);
                            break;
                        }
                    }
                }
                if ((quad = form.getFloatArray(1785890247)) == null) {
                    quad = form.getFloatArray(573911876);
                }
                BufferedImage icon = new BufferedImage(form.getBoundingRectangle().width, form.getBoundingRectangle().height, 6);
                Graphics g = icon.getGraphics();
                if (quad.length < 8) break;
                for (int hi = 0; hi != quad.length; hi += 8) {
                    int x = (int)quad[hi] - form.getBoundingRectangle().x;
                    int y = (int)quad[hi + 5] - form.getBoundingRectangle().y;
                    y = form.getBoundingRectangle().height - y - (int)(quad[hi + 1] - quad[hi + 5]);
                    int width = (int)(quad[hi + 2] - quad[hi]);
                    int height = (int)(quad[hi + 1] - quad[hi + 5]);
                    Rectangle rh = new Rectangle(x, y, width, height);
                    try {
                        g.setColor(c);
                        g.fillRect(rh.x, rh.y, rh.width, rh.height);
                        but.setBackground(new Color(0, 0, 0, 0));
                        but.setIcon(new FixImageIcon(icon, 0));
                        continue;
                    }
                    catch (Exception e) {
                        if (!LogWriter.isOutput()) continue;
                        LogWriter.writeLog("Exception: " + e.getMessage());
                    }
                }
                break;
            }
            case 2053993372: {
                float[] quad;
                if (!newAnnots) break;
                but.setBounds(form.getBoundingRectangle());
                float[] underlineColor = form.getFloatArray(19);
                Color c1 = new Color(0);
                if (underlineColor != null) {
                    switch (underlineColor.length) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            c1 = new Color(underlineColor[0], underlineColor[0], underlineColor[0], 1.0f);
                            break;
                        }
                        case 3: {
                            c1 = new Color(underlineColor[0], underlineColor[1], underlineColor[2], 1.0f);
                            break;
                        }
                        case 4: {
                            DeviceCMYKColorSpace cmyk = new DeviceCMYKColorSpace();
                            cmyk.setColor(underlineColor, 4);
                            c1 = new Color(cmyk.getColor().getRGB());
                            break;
                        }
                    }
                }
                if ((quad = form.getFloatArray(1785890247)) == null) {
                    quad = form.getFloatArray(573911876);
                }
                BufferedImage icon = new BufferedImage(form.getBoundingRectangle().width, form.getBoundingRectangle().height, 6);
                Graphics g = icon.getGraphics();
                if (quad.length < 8) break;
                for (int hi = 0; hi != quad.length; hi += 8) {
                    int x = (int)quad[hi] - form.getBoundingRectangle().x;
                    int y = (int)quad[hi + 5] - form.getBoundingRectangle().y;
                    y = form.getBoundingRectangle().height - y - (int)(quad[hi + 1] - quad[hi + 5]);
                    int width = (int)(quad[hi + 2] - quad[hi]);
                    int height = (int)(quad[hi + 1] - quad[hi + 5]);
                    Rectangle rh = new Rectangle(x, y, width, height);
                    try {
                        g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.0f));
                        g.fillRect(rh.x, rh.y, rh.width, rh.height);
                        g.setColor(c1);
                        g.fillRect(rh.x, rh.y + rh.height - 1, rh.width, 1);
                        but.setBackground(new Color(0, 0, 0, 0));
                        but.setIcon(new FixImageIcon(icon, 0));
                        continue;
                    }
                    catch (Exception e) {
                        if (!LogWriter.isOutput()) continue;
                        LogWriter.writeLog("Exception: " + e.getMessage());
                    }
                }
                break;
            }
            case 2036432546: {
                float[] quad;
                if (!newAnnots) break;
                float[] strikeColor = form.getFloatArray(19);
                Color c2 = new Color(0);
                if (strikeColor != null) {
                    switch (strikeColor.length) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            c2 = new Color(strikeColor[0], strikeColor[0], strikeColor[0], 1.0f);
                            break;
                        }
                        case 3: {
                            c2 = new Color(strikeColor[0], strikeColor[1], strikeColor[2], 1.0f);
                            break;
                        }
                        case 4: {
                            DeviceCMYKColorSpace cmyk = new DeviceCMYKColorSpace();
                            cmyk.setColor(strikeColor, 4);
                            c2 = new Color(cmyk.getColor().getRGB());
                            break;
                        }
                    }
                }
                if ((quad = form.getFloatArray(1785890247)) == null) {
                    quad = form.getFloatArray(573911876);
                }
                BufferedImage icon = new BufferedImage(form.getBoundingRectangle().width, form.getBoundingRectangle().height, 6);
                Graphics g = icon.getGraphics();
                if (quad.length < 8) break;
                for (int hi = 0; hi != quad.length; hi += 8) {
                    int x = (int)quad[hi] - form.getBoundingRectangle().x;
                    int y = (int)quad[hi + 5] - form.getBoundingRectangle().y;
                    y = form.getBoundingRectangle().height - y - (int)(quad[hi + 1] - quad[hi + 5]);
                    int width = (int)(quad[hi + 2] - quad[hi]);
                    int height = (int)(quad[hi + 1] - quad[hi + 5]);
                    Rectangle rh = new Rectangle(x, y, width, height);
                    try {
                        g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.0f));
                        g.fillRect(0, 0, rh.width, rh.height);
                        g.setColor(c2);
                        g.fillRect(rh.x, rh.y + rh.height / 2, rh.width, 1);
                        but.setBackground(new Color(0, 0, 0, 0));
                        but.setIcon(new FixImageIcon(icon, 0));
                        continue;
                    }
                    catch (Exception e) {
                        if (!LogWriter.isOutput()) continue;
                        LogWriter.writeLog("Exception: " + e.getMessage());
                    }
                }
                break;
            }
        }
        return but;
    }

    @Override
    public Object comboBox(FormObject form) {
        boolean[] flags;
        JComboBox<Object> comboBox;
        String[] items = form.getItemsList();
        if (items == null) {
            comboBox = new JComboBox();
        } else {
            comboBox = new JComboBox<String>(items);
            Color backgroundColor = FormObject.generateColor(form.getDictionary(7451).getFloatArray(4631));
            if (backgroundColor != null) {
                ComboColorRenderer renderer = new ComboColorRenderer(backgroundColor);
                comboBox.setRenderer(renderer);
            }
        }
        String textValue = form.getSelectedItem();
        if (form.getValuesMap(true) != null) {
            comboBox.setSelectedItem(form.getValuesMap(true).get(textValue));
        } else {
            comboBox.setSelectedItem(textValue);
        }
        if (this.printouts) {
            System.out.println("currently selected value=" + textValue);
        }
        if ((flags = form.getFieldFlags())[19]) {
            if (this.printouts) {
                System.out.println("drop list and an editable text box");
            }
            comboBox.setEditable(true);
        } else {
            if (this.printouts) {
                System.out.println("only a drop list");
            }
            comboBox.setEditable(false);
        }
        this.setupUniversalFeatures(comboBox, form);
        if (flags[1]) {
            comboBox.setEditable(false);
            comboBox.setEnabled(false);
            if (this.printouts) {
                System.out.println("READONLY_ID=" + comboBox);
            }
        }
        return comboBox;
    }

    @Override
    public Object checkBoxBut(FormObject form) {
        boolean[] flags;
        JCheckBox checkBut = new JCheckBox();
        this.setupButton(checkBut, form);
        this.setupUniversalFeatures(checkBut, form);
        if (checkBut.getBorder() != null) {
            checkBut.setBorderPainted(true);
        }
        if ((flags = form.getFieldFlags()) != null && flags[1]) {
            checkBut.setEnabled(false);
            checkBut.setDisabledIcon(checkBut.getIcon());
            checkBut.setDisabledSelectedIcon(checkBut.getSelectedIcon());
        }
        return checkBut;
    }

    @Override
    public Object listField(FormObject form) {
        String[] items = form.getItemsList();
        JList<Object> list = items != null ? new JList<String>(items) : new JList();
        if (!form.getFieldFlags()[22]) {
            list.setSelectionMode(0);
        }
        if (form.getTopIndex() != null) {
            list.setSelectedIndices(form.getTopIndex());
            if (this.printouts) {
                System.out.println("topIndex should be=" + ConvertToString.convertArrayToString(form.getTopIndex()));
            }
        } else {
            String textValue = form.getSelectedItem();
            if (form.getValuesMap(true) != null) {
                list.setSelectedValue(form.getValuesMap(true).get(textValue), true);
            } else {
                list.setSelectedValue(textValue, true);
            }
            if (this.printouts) {
                System.out.println("currently selected value=" + textValue);
            }
        }
        this.setupUniversalFeatures(list, form);
        return list;
    }

    @Override
    public Object multiLinePassword(FormObject form) {
        String textValue = form.getTextString();
        int maxLength = form.getInt(1209815663);
        JPasswordField multipass = maxLength != -1 ? new JPasswordField(textValue, maxLength) : new JPasswordField(textValue);
        multipass.setEchoChar('*');
        this.setupUniversalFeatures(multipass, form);
        this.setupTextFeatures(multipass, form);
        boolean[] flags = form.getFieldFlags();
        if (flags != null && flags[1]) {
            multipass.setEditable(false);
            if (this.printouts) {
                System.out.println("READONLY_ID=" + multipass);
            }
        }
        SwingFormFactory.setToolTip(form, multipass);
        return multipass;
    }

    @Override
    public Object multiLineText(FormObject form) {
        boolean[] flags = form.getFieldFlags();
        boolean[] characteristics = form.getCharacteristics();
        JTextArea newTextarea = new JTextArea(form.getTextString());
        newTextarea.setLineWrap(true);
        newTextarea.setWrapStyleWord(true);
        newTextarea.getDocument().addDocumentListener(new TextDocumentListener(newTextarea, form));
        JTextArea comp = newTextarea;
        SwingFormFactory.setToolTip(form, comp);
        this.setupUniversalFeatures(comp, form);
        form.setGUIType(0);
        return comp;
    }

    @Override
    public Object signature(FormObject form) {
        JButton sigBut = new JButton();
        this.setupButton(sigBut, form);
        this.setupUniversalFeatures(sigBut, form);
        boolean[] flags = form.getFieldFlags();
        if (flags != null && flags[1]) {
            sigBut.setEnabled(false);
            sigBut.setDisabledIcon(sigBut.getIcon());
            sigBut.setDisabledSelectedIcon(sigBut.getSelectedIcon());
        }
        if (!form.isAppearanceUsed()) {
            sigBut.setOpaque(false);
            BufferedImage img = new BufferedImage(1, 1, 2);
            Graphics2D imgG2 = img.createGraphics();
            imgG2.setPaint(new Color(221, 228, 255, 175));
            imgG2.fillRect(0, 0, 1, 1);
            sigBut.setIcon(new FixImageIcon(img, 0));
        }
        return sigBut;
    }

    @Override
    public Object pushBut(FormObject form) {
        JButton pushBut = new JButton();
        this.setupButton(pushBut, form);
        this.setupUniversalFeatures(pushBut, form);
        boolean[] flags = form.getFieldFlags();
        if (flags != null && flags[1]) {
            pushBut.setEnabled(false);
            pushBut.setDisabledIcon(pushBut.getIcon());
            pushBut.setDisabledSelectedIcon(pushBut.getSelectedIcon());
        }
        return pushBut;
    }

    @Override
    public Object radioBut(FormObject form) {
        JRadioButton radioBut = new JRadioButton();
        this.setupButton(radioBut, form);
        this.setupUniversalFeatures(radioBut, form);
        boolean[] flags = form.getFieldFlags();
        if (flags != null && flags[1]) {
            radioBut.setEnabled(false);
            radioBut.setDisabledIcon(radioBut.getIcon());
            radioBut.setDisabledSelectedIcon(radioBut.getSelectedIcon());
        }
        return radioBut;
    }

    @Override
    public Object singleLinePassword(FormObject form) {
        JPasswordField newPassword = new JPasswordField(form.getTextString());
        newPassword.setEchoChar('*');
        int maxLength = form.getInt(1209815663);
        if (maxLength != -1) {
            newPassword.setColumns(maxLength);
            if (this.printouts) {
                System.out.println("textlength added=" + maxLength);
            }
        }
        this.setupUniversalFeatures(newPassword, form);
        this.setupTextFeatures(newPassword, form);
        boolean[] flags = form.getFieldFlags();
        if (flags != null && flags[1]) {
            newPassword.setEditable(false);
            if (this.printouts) {
                System.out.println("READONLY_ID=" + newPassword);
            }
        }
        SwingFormFactory.setToolTip(form, newPassword);
        return newPassword;
    }

    @Override
    public Object singleLineText(FormObject form) {
        boolean[] flags = form.getFieldFlags();
        boolean[] characteristics = form.getCharacteristics();
        JTextField retComp = null;
        if (flags != null && flags[1] || characteristics != null && characteristics[9]) {
            JTextField newTextfield = new JTextField(form.getTextString());
            this.setupTextFeatures(newTextfield, form);
            SwingFormFactory.setToolTip(form, newTextfield);
            newTextfield.setEditable(false);
            retComp = newTextfield;
        } else {
            JTextField newTextfield = new JTextField(form.getTextString());
            this.setupTextFeatures(newTextfield, form);
            SwingFormFactory.setToolTip(form, newTextfield);
            retComp = newTextfield;
        }
        this.setupUniversalFeatures(retComp, form);
        return retComp;
    }

    private void setupTextFeatures(JTextField textcomp, FormObject form) {
        if (form.getAlignment() != -1) {
            textcomp.setHorizontalAlignment(form.getAlignment());
        }
        textcomp.getDocument().addDocumentListener(new TextDocumentListener(textcomp, form));
        form.setGUIType(0);
    }

    private void setupButton(AbstractButton comp, FormObject form) {
        int textPosition;
        String normalCaption = form.getDictionary(7451).getTextStreamValue(4881);
        comp.setText(normalCaption);
        comp.setContentAreaFilled(false);
        String downCaption = form.getDictionary(7451).getTextStreamValue(4371);
        String rolloverCaption = form.getDictionary(7451).getTextStreamValue(8723);
        if (downCaption != null && downCaption.length() > 0 || rolloverCaption != null && rolloverCaption.length() > 0) {
            comp.addMouseListener((MouseListener)this.formsActionHandler.setupChangingCaption(normalCaption, rolloverCaption, downCaption));
        }
        if (form.isAppearanceUsed()) {
            this.setAPImages(form, comp);
        }
        if ((textPosition = form.getTextPosition()) != -1) {
            switch (textPosition) {
                case 0: {
                    comp.setIcon(null);
                    comp.setText(normalCaption);
                    break;
                }
                case 1: {
                    comp.setText(null);
                    break;
                }
                case 2: {
                    comp.setVerticalTextPosition(3);
                    break;
                }
                case 3: {
                    comp.setVerticalTextPosition(1);
                    break;
                }
                case 4: {
                    comp.setHorizontalTextPosition(4);
                    break;
                }
                case 5: {
                    comp.setHorizontalTextPosition(2);
                    break;
                }
                case 6: {
                    comp.setText(null);
                }
            }
        }
        Insets insetZero = new Insets(0, 0, 0, 0);
        comp.setMargin(insetZero);
        comp.addMouseListener((MouseListener)this.formsActionHandler.setHoverCursor());
    }

    private void setAPImages(FormObject form, Object rawComp) {
        boolean showImages = false;
        AbstractButton comp = (AbstractButton)rawComp;
        BufferedImage normalOff = null;
        BufferedImage normalOn = null;
        BufferedImage downOff = null;
        BufferedImage downOn = null;
        if (form.hasNormalOff()) {
            comp.setText(null);
            normalOff = form.getNormalOffImage();
            comp.setIcon(new FixImageIcon(normalOff, form.getDictionary(7451).getInt(34)));
        }
        if (form.hasNormalOn()) {
            comp.setText(null);
            normalOn = form.getNormalOnImage();
            comp.setSelectedIcon(new FixImageIcon(normalOn, form.getDictionary(7451).getInt(34)));
        }
        if (form.hasNoDownIcon()) {
            comp.setPressedIcon(comp.getIcon());
        } else if (!form.hasDownImage()) {
            if (form.hasNormalOff()) {
                if (form.hasNormalOn()) {
                    if (form.hasOffsetDownIcon()) {
                        downOn = this.createPressedLook(normalOn);
                        downOff = this.createPressedLook(normalOff);
                    } else {
                        downOff = this.invertImage(normalOff);
                        downOn = this.invertImage(normalOn);
                    }
                } else {
                    downOff = form.hasOffsetDownIcon() ? this.createPressedLook(normalOff) : this.invertImage(normalOff);
                }
            } else if (form.hasNormalOn()) {
                downOff = form.hasOffsetDownIcon() ? this.createPressedLook(normalOn) : this.invertImage(normalOn);
            }
        } else {
            downOff = form.getDownOffImage();
            downOn = form.getDownOnImage();
        }
        if (downOff == null || downOn == null) {
            if (downOff != null) {
                comp.setText(null);
                comp.setPressedIcon(new FixImageIcon(downOff, form.getDictionary(7451).getInt(34)));
            } else if (downOn != null) {
                comp.setText(null);
                comp.setPressedIcon(new FixImageIcon(downOn, form.getDictionary(7451).getInt(34)));
            }
        } else {
            comp.setPressedIcon(new FixImageIcon(downOn, downOff, form.getDictionary(7451).getInt(34), comp.isSelected() ? 1 : 0));
            comp.addActionListener((ActionListener)this.formsActionHandler.setupChangingDownIcon(downOff, downOn, form.getDictionary(7451).getInt(34)));
        }
        if (form.hasRolloverOff()) {
            comp.setRolloverEnabled(true);
            comp.setText(null);
            comp.setRolloverIcon(new FixImageIcon(form.getRolloverOffImage(), form.getDictionary(7451).getInt(34)));
        }
        if (form.hasRolloverOn()) {
            comp.setRolloverEnabled(true);
            comp.setText(null);
            comp.setRolloverSelectedIcon(new FixImageIcon(form.getRolloverOnImage(), form.getDictionary(7451).getInt(34)));
        }
        String defaultState = form.getName(4387);
        if (this.printouts) {
            System.out.println("default state=" + defaultState);
        }
        if (defaultState != null && defaultState.equals(form.getNormalOnState())) {
            Icon icn;
            comp.setSelected(true);
            if (comp instanceof JToggleButton && (icn = comp.getPressedIcon()) != null && icn instanceof FixImageIcon) {
                ((FixImageIcon)icn).swapImage(true);
            }
            this.acrorend.getCompData().flagLastUsedValue(comp, form, false);
        }
    }

    private void setupUniversalFeatures(JComponent comp, FormObject form) {
        Color backgroundColor;
        comp.setOpaque(false);
        Font textFont = form.getTextFont();
        if (textFont != null) {
            comp.setFont(textFont);
        }
        comp.setForeground(form.getTextColor());
        Border newBorder = (Border)this.acrorend.getCompData().generateBorderfromForm(form, 1.0f);
        comp.setBorder(newBorder);
        if (this.printouts) {
            System.out.println("borderStyle=" + newBorder);
        }
        if ((backgroundColor = FormObject.generateColor(form.getDictionary(7451).getFloatArray(4631))) != null) {
            comp.setBackground(backgroundColor);
            comp.setOpaque(true);
        } else if (DecoderOptions.isRunningOnMac && comp instanceof JButton) {
            ((JButton)comp).setBorderPainted(false);
            comp.setBorder(null);
        }
        this.setupMouseListener(comp, form);
        if (this.printouts) {
            System.out.println("flagNum=" + form.getCharacteristics());
        }
    }

    private void setupMouseListener(Component currentComp, FormObject form) {
        String noLinkToolTips;
        boolean[] characteristic = form.getCharacteristics();
        if (characteristic[0] || characteristic[1] || characteristic[5]) {
            currentComp.setVisible(false);
        }
        SwingListener jpedalListener = new SwingListener(form, this.acrorend, this.formsActionHandler);
        if (currentComp instanceof JComboBox) {
            ((JComboBox)currentComp).getComponent(0).addMouseListener(jpedalListener);
            ((JComboBox)currentComp).getComponent(0).addKeyListener(jpedalListener);
            ((JComboBox)currentComp).getComponent(0).addFocusListener(jpedalListener);
            ((JComboBox)currentComp).addActionListener(jpedalListener);
        }
        if (currentComp instanceof JList) {
            ((JList)currentComp).addListSelectionListener(jpedalListener);
        }
        currentComp.addMouseListener(jpedalListener);
        currentComp.addMouseMotionListener(jpedalListener);
        currentComp.addKeyListener(jpedalListener);
        currentComp.addFocusListener(jpedalListener);
        PdfObject aData = form.getDictionary(17);
        if (!(aData == null || aData.getNameAsConstant(35) != 2433561 || (noLinkToolTips = System.getProperty("org.jpedal.noURLaccess")) != null && noLinkToolTips.equals("true"))) {
            String text = aData.getTextStreamValue(2433561);
            ((JComponent)currentComp).setToolTipText(text);
        }
    }

    private static void setToolTip(FormObject formObject, JComponent retComponent) {
        String userName = formObject.getTextStreamValue(9253);
        if (userName != null) {
            retComponent.setToolTipText(userName);
        }
    }

    @Override
    public GUIData getCustomCompData() {
        return new SwingData();
    }

    @Override
    public ActionFactory getActionFactory() {
        SwingActionFactory fact = new SwingActionFactory();
        fact.setPDF(this.formsActionHandler.getPDFDecoder(), this.acrorend);
        return fact;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public void setAnnotOrder(Map annotOrder) {
    }

    static class ComboColorRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 7337739942496736151L;
        Color color = Color.RED;

        public ComboColorRenderer(Color col) {
            this.color = col;
            this.setBorder(null);
            this.setOpaque(true);
        }

        public ComboColorRenderer() {
            this.setBorder(null);
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setBackground(this.color);
            if (value == null || ((String)value).length() == 0) {
                this.setText(" ");
            } else {
                this.setText((String)value);
            }
            return this;
        }
    }

    class TextDocumentListener
    implements DocumentListener {
        JTextComponent textcomp;
        FormObject form;

        public TextDocumentListener(JTextComponent textcomp, FormObject form) {
            this.textcomp = textcomp;
            this.form = form;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.updateFormValue();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updateFormValue();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updateFormValue();
        }

        private void updateFormValue() {
            this.form.updateValue(0, this.textcomp.getText(), false);
        }
    }
}

