/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.utils;

import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConvertToString {
    public static final String convertMapToString(NamedNodeMap currentMap) {
        if (currentMap == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < currentMap.getLength(); ++i) {
            Node node = currentMap.item(i);
            buf.append('\t');
            buf.append(node.getNodeName());
            buf.append('=');
            buf.append(node.getNodeValue());
            buf.append('\n');
        }
        return buf.toString();
    }

    public static final String convertMapToString(Map currentMap) {
        if (currentMap == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (Object node : currentMap.keySet()) {
            buf.append('\t');
            buf.append(node);
            buf.append('=');
            buf.append(currentMap.get(node));
            buf.append('\n');
        }
        return buf.toString();
    }

    public static final String convertArrayToString(String[] items) {
        if (items != null) {
            StringBuilder ret = new StringBuilder();
            for (int i = 0; i < items.length; ++i) {
                if (i > 0) {
                    ret.append(", ");
                }
                ret.append(items[i]);
            }
            return ret.toString();
        }
        return null;
    }

    public static String convertArrayToString(boolean[] flags) {
        if (flags != null) {
            StringBuilder ret = new StringBuilder();
            for (int i = 0; i < flags.length; ++i) {
                if (i > 0) {
                    ret.append(", ");
                }
                ret.append(i);
                ret.append('=');
                ret.append(flags[i]);
            }
            return ret.toString();
        }
        return null;
    }

    public static String convertArrayToString(float[] values) {
        if (values != null) {
            StringBuilder ret = new StringBuilder();
            for (int i = 0; i < values.length; ++i) {
                if (i > 0) {
                    ret.append(", ");
                }
                ret.append(values[i]);
            }
            return ret.toString();
        }
        return null;
    }

    public static String convertArrayToString(float[][] values) {
        if (values != null) {
            StringBuilder ret = new StringBuilder();
            ret.append('[');
            for (int i = 0; i < values.length; ++i) {
                ret.append('{');
                for (int j = 0; j < values[i].length; ++j) {
                    if (i > 0) {
                        ret.append(", ");
                    }
                    ret.append(values[i][j]);
                }
                ret.append("}, ");
            }
            ret.append(']');
            return ret.toString();
        }
        return null;
    }

    public static String convertArrayToString(int[] items) {
        if (items != null) {
            StringBuilder ret = new StringBuilder();
            for (int i = 0; i < items.length; ++i) {
                if (i > 0) {
                    ret.append(", ");
                }
                ret.append(items[i]);
            }
            return ret.toString();
        }
        return null;
    }

    public static String convertArrayToString(Rectangle[] boxes) {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < boxes.length; ++i) {
            if (i > 0) {
                ret.append(",\n ");
            }
            ret.append(boxes[i].x);
            ret.append(' ');
            ret.append(boxes[i].y);
            ret.append(' ');
            ret.append(boxes[i].width);
            ret.append(' ');
            ret.append(boxes[i].height);
        }
        return ret.toString();
    }

    public static String convertArrayToString(Object[] components) {
        StringBuilder ret = new StringBuilder();
        ret.append("count=");
        ret.append(components.length);
        for (Object component : components) {
            ret.append('\n');
            ret.append(component);
        }
        return ret.toString();
    }

    public static String convertArrayToString(List data) {
        if (data == null) {
            return "null";
        }
        StringBuilder ret = new StringBuilder();
        ret.append("count=");
        ret.append(data.size());
        for (Object aData : data) {
            ret.append('\n');
            ret.append(aData);
        }
        return ret.toString();
    }

    public static String convertArrayToString(Set data) {
        if (data == null) {
            return "null";
        }
        return ConvertToString.convertArrayToString(data.toArray());
    }

    public static String convertArrayToString(Boolean[] flags) {
        if (flags != null) {
            StringBuilder ret = new StringBuilder();
            for (int i = 0; i < flags.length; ++i) {
                if (i > 0) {
                    ret.append(", ");
                }
                ret.append(i);
                ret.append('=');
                ret.append(flags[i]);
            }
            return ret.toString();
        }
        return null;
    }

    public static String convertButtonGroupToString(ButtonGroup bg) {
        if (bg == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(bg.getButtonCount());
        buf.append('\n');
        Enumeration<AbstractButton> list = bg.getElements();
        while (list.hasMoreElements()) {
            buf.append(list.nextElement());
            buf.append('\n');
        }
        return buf.toString();
    }

    public static void printStackTrace(int level) {
        ConvertToString.printStackTrace(2, level + 1, false);
    }

    public static void printStackTrace(int startLevel, int endLevel, boolean err) {
        Throwable stackgetter = new Throwable();
        StackTraceElement[] elems = stackgetter.getStackTrace();
        if (endLevel == -1 || endLevel > elems.length - 1) {
            endLevel = elems.length - 1;
        }
        for (int i = startLevel; i <= endLevel; ++i) {
            if (err) {
                System.err.println(elems[i]);
                continue;
            }
            System.out.println(elems[i]);
        }
    }

    public static String convertDocumentToString(Node formData) {
        return ConvertToString.convertDocumentToString(formData, 0);
    }

    private static String convertDocumentToString(Node formData, int level) {
        if (formData == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(formData.getNodeName());
        buf.append(" = ");
        buf.append(formData.getNodeValue());
        buf.append(" type=");
        buf.append(formData.getNodeType());
        buf.append(" textContent=");
        buf.append(formData.getTextContent());
        NamedNodeMap att = formData.getAttributes();
        if (att != null) {
            buf.append(" attributes=[");
            for (int i = 0; i < att.getLength(); ++i) {
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(att.item(i));
            }
            buf.append(']');
        }
        NodeList nodes = formData.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            buf.append('\n');
            for (int d = 0; d < level; ++d) {
                buf.append('|');
            }
            buf.append(ConvertToString.convertDocumentToString(nodes.item(i), level + 1));
        }
        return buf.toString();
    }
}

