/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import org.jpedal.color.ColorspaceFactory;
import org.jpedal.color.DeviceCMYKColorSpace;
import org.jpedal.color.DeviceGrayColorSpace;
import org.jpedal.color.DeviceRGBColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.raw.ColorSpaceObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.CommandParser;
import org.jpedal.parser.PdfObjectCache;
import org.jpedal.utils.StringUtils;

public class ColorCommands {
    static void CS(boolean isLowerCase, String colorspaceObject, GraphicsState gs, PdfObjectCache cache, PdfObjectReader currentPdfFile, boolean isPrinting, int pageNum, PdfPageData pageData, boolean alreadyUsed) {
        GenericColorSpace newColorSpace;
        boolean isStroke = !isLowerCase;
        PdfObject ColorSpace2 = (PdfObject)cache.get(2, colorspaceObject);
        if (ColorSpace2 == null) {
            ColorSpace2 = new ColorSpaceObject(StringUtils.toBytes(colorspaceObject));
        }
        String ref = ColorSpace2.getObjectRefAsString();
        String ref2 = ref + '-' + isLowerCase;
        if (!alreadyUsed && cache.colorspacesObjects.containsKey(ref)) {
            newColorSpace = (GenericColorSpace)cache.colorspacesObjects.get(ref);
            newColorSpace.reset();
        } else if (alreadyUsed && cache.colorspacesObjects.containsKey(ref2)) {
            newColorSpace = (GenericColorSpace)cache.colorspacesObjects.get(ref2);
            newColorSpace.reset();
        } else {
            newColorSpace = ColorspaceFactory.getColorSpaceInstance(currentPdfFile, ColorSpace2);
            newColorSpace.setPrinting(isPrinting);
            if (newColorSpace.getID() == 1247168582 || newColorSpace.getID() == -2073385820) {
                if (!alreadyUsed) {
                    cache.colorspacesObjects.put(ref, newColorSpace);
                } else {
                    cache.colorspacesObjects.put(ref2, newColorSpace);
                }
            }
        }
        if (newColorSpace.getID() == 1146450818) {
            newColorSpace.setPattern(cache.patterns, pageData.getMediaBoxWidth(pageNum), pageData.getMediaBoxHeight(pageNum), gs.CTM);
            newColorSpace.setGS(gs);
        }
        cache.put(1, newColorSpace.getID(), "x");
        if (isStroke) {
            gs.strokeColorSpace = newColorSpace;
        } else {
            gs.nonstrokeColorSpace = newColorSpace;
        }
    }

    static void G(boolean isLowerCase, GraphicsState gs, CommandParser parser, PdfObjectCache cache) {
        boolean isStroke = !isLowerCase;
        float[] operand = parser.getValuesAsFloat();
        int operandCount = operand.length;
        if (isStroke) {
            if (gs.strokeColorSpace.getID() != 1568372915) {
                gs.strokeColorSpace = new DeviceGrayColorSpace();
            }
            gs.strokeColorSpace.setColor(operand, operandCount);
            cache.put(1, gs.strokeColorSpace.getID(), "x");
        } else {
            if (gs.nonstrokeColorSpace.getID() != 1568372915) {
                gs.nonstrokeColorSpace = new DeviceGrayColorSpace();
            }
            gs.nonstrokeColorSpace.setColor(operand, operandCount);
            cache.put(1, gs.nonstrokeColorSpace.getID(), "x");
        }
    }

    static void K(boolean isLowerCase, GraphicsState gs, CommandParser parser, PdfObjectCache cache) {
        boolean isStroke = !isLowerCase;
        float[] operand = parser.getValuesAsFloat();
        int operandCount = operand.length;
        if (operandCount > 3) {
            float[] tempValues = new float[operandCount];
            for (int ii = 0; ii < operandCount; ++ii) {
                tempValues[operandCount - ii - 1] = operand[ii];
            }
            operand = tempValues;
            if (isStroke) {
                if (gs.strokeColorSpace.getID() != 1498837125) {
                    gs.strokeColorSpace = new DeviceCMYKColorSpace();
                }
                gs.strokeColorSpace.setColor(operand, operandCount);
                cache.put(1, gs.strokeColorSpace.getID(), "x");
            } else {
                if (gs.nonstrokeColorSpace.getID() != 1498837125) {
                    gs.nonstrokeColorSpace = new DeviceCMYKColorSpace();
                }
                gs.nonstrokeColorSpace.setColor(operand, operandCount);
                cache.put(1, gs.nonstrokeColorSpace.getID(), "x");
            }
        }
    }

    static void RG(boolean isLowerCase, GraphicsState gs, CommandParser parser, PdfObjectCache cache) {
        boolean isStroke = !isLowerCase;
        float[] operand = parser.getValuesAsFloat();
        int operandCount = operand.length;
        float[] tempValues = new float[operandCount];
        for (int ii = 0; ii < operandCount; ++ii) {
            tempValues[operandCount - ii - 1] = operand[ii];
        }
        operand = tempValues;
        if (isStroke) {
            if (gs.strokeColorSpace.getID() != 1785221209) {
                gs.strokeColorSpace = new DeviceRGBColorSpace();
            }
            gs.strokeColorSpace.setColor(operand, operandCount);
            cache.put(1, gs.strokeColorSpace.getID(), "x");
        } else {
            if (gs.nonstrokeColorSpace.getID() != 1785221209) {
                gs.nonstrokeColorSpace = new DeviceRGBColorSpace();
            }
            gs.nonstrokeColorSpace.setColor(operand, operandCount);
            cache.put(1, gs.nonstrokeColorSpace.getID(), "x");
        }
    }

    static void SCN(boolean isLowerCase, GraphicsState gs, CommandParser parser, PdfObjectCache cache) {
        if (isLowerCase) {
            if (gs.nonstrokeColorSpace.getID() == 1146450818) {
                String[] vals = parser.getValuesAsString();
                gs.nonstrokeColorSpace.setColor(vals, vals.length);
            } else {
                float[] values = parser.getValuesAsFloat();
                int operandCount = values.length;
                float[] tempValues = new float[operandCount];
                for (int ii = 0; ii < operandCount; ++ii) {
                    tempValues[operandCount - ii - 1] = values[ii];
                }
                values = tempValues;
                gs.nonstrokeColorSpace.setColor(values, operandCount);
            }
            cache.put(1, gs.nonstrokeColorSpace.getID(), "x");
        } else {
            if (gs.strokeColorSpace.getID() == 1146450818) {
                String[] vals = parser.getValuesAsString();
                gs.strokeColorSpace.setColor(vals, vals.length);
            } else {
                float[] values = parser.getValuesAsFloat();
                int operandCount = values.length;
                float[] tempValues = new float[operandCount];
                for (int ii = 0; ii < operandCount; ++ii) {
                    tempValues[operandCount - ii - 1] = values[ii];
                }
                values = tempValues;
                gs.strokeColorSpace.setColor(values, operandCount);
            }
            cache.put(1, gs.strokeColorSpace.getID(), "x");
        }
    }
}

