/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.util.ArrayList;
import org.jpedal.exception.PdfException;
import org.jpedal.fonts.glyph.T3Size;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.acroforms.rendering.AcroRenderer;
import org.jpedal.objects.layers.PdfLayerList;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.PdfStreamDecoder;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XFAStreamDecoder
extends PdfStreamDecoder {
    AcroRenderer formRenderer;

    public XFAStreamDecoder(PdfObjectReader currentPdfFile, boolean useHiResImageForDisplay, PdfLayerList pdfLayerList, AcroRenderer formRenderer) {
        super(currentPdfFile, useHiResImageForDisplay, pdfLayerList);
        this.formRenderer = formRenderer;
    }

    @Override
    public final T3Size decodePageContent(PdfObject pdfObject) throws PdfException {
        Node root = this.formRenderer.getXFA(1013350773);
        XFAStreamDecoder.parseNode(root, new ArrayList<Node>(), 0);
        return null;
    }

    private static void parseNode(Node nodeToParse, ArrayList<Node> nodeList, int indent) {
        for (int ii = 0; ii < indent; ++ii) {
            System.out.print(" ");
        }
        System.out.print(nodeToParse);
        System.out.println("[" + nodeToParse.getTextContent() + " ]");
        nodeList.add(nodeToParse);
        NodeList setOfNodes = nodeToParse.getChildNodes();
        for (int i = 0; i < setOfNodes.getLength(); ++i) {
            XFAStreamDecoder.parseNode(setOfNodes.item(i), nodeList, indent + 3);
        }
    }
}

