/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.Set;
import org.jpedal.PdfDecoder;
import org.jpedal.color.ColorSpaces;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ColorHandler;
import org.jpedal.external.ImageHandler;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.GraphicsState;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.RenderUtils;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Matrix;
import org.jpedal.utils.repositories.Vector_Rectangle;

public class BaseDisplay
implements DynamicVectorRenderer {
    protected int type;
    private int formNum = 0;
    boolean isType3Font = false;
    protected boolean addBackground = true;
    protected Vector_Rectangle areas;
    protected ObjectStore objectStoreRef;
    protected int currentItem = -1;
    protected int endItem = -1;
    protected int pageRotation = 0;
    Area lastClip = null;
    boolean hasClips = false;
    boolean colorsLocked;
    Graphics2D g2;
    boolean optimisedTurnCode = true;
    boolean useHiResImageForDisplay = false;
    boolean extraRot = false;
    String rawKey = null;
    PdfPaint fillCol = null;
    PdfPaint strokeCol = null;
    public int pageNumber = 0;
    int xx = 0;
    int yy = 0;
    public static boolean invertHighlight = false;
    boolean isPrinting;
    ImageHandler customImageHandler = null;
    ColorHandler customColorHandler = null;
    double cropX;
    double cropH;
    float scaling;
    float lastScaling;
    int w = 0;
    int h = 0;
    protected Color backgroundColor = Color.WHITE;
    protected Color textColor = null;
    protected int colorThresholdToReplace = 255;
    protected boolean changeLineArtAndText = false;
    public static RenderingHints userHints = null;

    @Override
    public void setInset(int x, int y) {
        this.xx = x;
        this.yy = y;
    }

    @Override
    public void setG2(Graphics2D g2) {
        this.g2 = g2;
        if (userHints != null) {
            this.g2.setRenderingHints(userHints);
        }
    }

    @Override
    public void init(int width, int height, int rawRotation, Color backgroundColor) {
        this.w = width;
        this.h = height;
        this.pageRotation = rawRotation;
        this.backgroundColor = backgroundColor;
    }

    @Override
    public void paintBackground(Shape dirtyRegion) {
        if (this.addBackground && this.g2 != null) {
            this.g2.setColor(this.backgroundColor);
            if (dirtyRegion == null) {
                this.g2.fill(new Rectangle(this.xx, this.yy, (int)((float)this.w * this.scaling), (int)((float)this.h * this.scaling)));
            } else {
                this.g2.fill(dirtyRegion);
            }
        }
    }

    protected boolean checkColorThreshold(int col) {
        int r = col & 0xFF;
        int g = col >> 8 & 0xFF;
        int b = col >> 16 & 0xFF;
        return r <= this.colorThresholdToReplace && g <= this.colorThresholdToReplace && b <= this.colorThresholdToReplace;
    }

    void renderEmbeddedText(int text_fill_type, Object rawglyph, int glyphType, AffineTransform glyphAT, Rectangle textHighlight, PdfPaint strokePaint, PdfPaint fillPaint, float strokeOpacity, float fillOpacity, int lineWidth) {
        float strokeOnlyLine = 0.0f;
        if (text_fill_type == 1 && (double)lineWidth >= 1.0) {
            strokeOnlyLine = this.scaling;
        }
        PdfGlyph glyph = (PdfGlyph)rawglyph;
        AffineTransform at = this.g2.getTransform();
        double[] affValues = new double[6];
        at.getMatrix(affValues);
        if (glyph != null) {
            Color color;
            Stroke currentStoke = this.g2.getStroke();
            if (lineWidth != 0) {
                float w = (float)lineWidth * (float)this.g2.getTransform().getScaleX();
                if (w < 0.0f) {
                    w = -w;
                }
                this.g2.setStroke(new BasicStroke(w));
            }
            this.g2.transform(glyphAT);
            Composite comp = this.g2.getComposite();
            if ((text_fill_type & 2) == 2) {
                if (this.textColor != null && (this.currentItem == -1 || this.endItem == -1 || this.currentItem <= this.endItem) && this.checkColorThreshold(fillPaint.getRGB())) {
                    fillPaint = new PdfColor(this.textColor.getRed(), this.textColor.getGreen(), this.textColor.getBlue());
                }
                fillPaint.setScaling(this.cropX, this.cropH, this.scaling, 0.0f, 0.0f);
                if (this.customColorHandler != null) {
                    this.customColorHandler.setPaint(this.g2, fillPaint, this.pageNumber, this.isPrinting);
                } else if (PdfDecoder.Helper != null) {
                    PdfDecoder.Helper.setPaint(this.g2, fillPaint, this.pageNumber, this.isPrinting);
                } else {
                    this.g2.setPaint(fillPaint);
                }
                if (fillOpacity != 1.0f) {
                    this.g2.setComposite(AlphaComposite.getInstance(3, fillOpacity));
                }
                if (textHighlight != null) {
                    if (invertHighlight) {
                        color = this.g2.getColor();
                        this.g2.setColor(new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue()));
                    } else if (DecoderOptions.backgroundColor != null) {
                        this.g2.setColor(DecoderOptions.backgroundColor);
                    }
                }
                if (glyphType == 6 && !glyph.ignoreColors()) {
                    glyph.setT3Colors(strokePaint, fillPaint, false);
                }
                glyph.render(2, this.g2, this.scaling, false);
                this.g2.setComposite(comp);
            }
            if (text_fill_type == 1) {
                glyph.setStrokedOnly(true);
            }
            if (!(DecoderOptions.isRunningOnMac && this.isPrinting && text_fill_type == 3 || (text_fill_type & 1) != 1)) {
                block32: {
                    if (strokePaint != null) {
                        if (this.textColor != null && (this.currentItem == -1 || this.endItem == -1 || this.currentItem <= this.endItem) && this.checkColorThreshold(strokePaint.getRGB())) {
                            strokePaint = new PdfColor(this.textColor.getRed(), this.textColor.getGreen(), this.textColor.getBlue());
                        }
                        strokePaint.setScaling(this.cropX, this.cropH, this.scaling, 0.0f, 0.0f);
                    }
                    if (this.customColorHandler != null) {
                        this.customColorHandler.setPaint(this.g2, strokePaint, this.pageNumber, this.isPrinting);
                    } else if (PdfDecoder.Helper != null) {
                        PdfDecoder.Helper.setPaint(this.g2, strokePaint, this.pageNumber, this.isPrinting);
                    } else {
                        this.g2.setPaint(strokePaint);
                    }
                    if (strokeOpacity != 1.0f) {
                        this.g2.setComposite(AlphaComposite.getInstance(3, strokeOpacity));
                    }
                    if (textHighlight != null) {
                        if (invertHighlight) {
                            color = this.g2.getColor();
                            this.g2.setColor(new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue()));
                        } else if (DecoderOptions.backgroundColor != null) {
                            this.g2.setColor(DecoderOptions.backgroundColor);
                        }
                    }
                    try {
                        glyph.render(1, this.g2, strokeOnlyLine, false);
                    }
                    catch (Exception e) {
                        if (!LogWriter.isOutput()) break block32;
                        LogWriter.writeLog("Exception: " + e.getMessage());
                    }
                }
                this.g2.setComposite(comp);
            }
            this.g2.setTransform(at);
            if (lineWidth != 0) {
                this.g2.setStroke(currentStoke);
            }
        }
    }

    public void renderXForm(DynamicVectorRenderer dvr, float nonstrokeAlpha) {
        Shape clip = null;
        if (this.g2 != null) {
            clip = this.g2.getClip();
        }
        Rectangle area = dvr.getOccupiedArea();
        int fx = area.x;
        int fw = area.width;
        int fy = area.y;
        int fh = area.height;
        if (fx < 0) {
            fx = 0;
        }
        if (fy > 0) {
            fh += fy;
        }
        if (fw <= 0 || fh <= 0) {
            return;
        }
        BufferedImage formImg = new BufferedImage(fw, fh, 2);
        Graphics2D formG2 = formImg.createGraphics();
        if (this.g2 == null) {
            formG2.scale(1.0, -1.0);
            formG2.translate(0, -fh);
        }
        formG2.translate(-fx, 0);
        dvr.setG2(formG2);
        dvr.paint(null, null, null);
        if (this.g2 != null) {
            this.g2.setClip(null);
        }
        GraphicsState gs = new GraphicsState();
        gs.CTM[0][0] = fw;
        gs.CTM[1][0] = 0.0f;
        gs.CTM[2][0] = 0.0f;
        gs.CTM[0][1] = 0.0f;
        gs.CTM[1][1] = fh;
        gs.CTM[2][1] = 0.0f;
        gs.CTM[0][2] = 0.0f;
        gs.CTM[1][2] = 0.0f;
        gs.CTM[2][2] = 1.0f;
        if (this.g2 != null) {
            this.g2.translate(fx, 0);
            this.renderImage(new AffineTransform(), formImg, nonstrokeAlpha, gs, area.x, area.y, 1);
            this.g2.translate(-fx, 0);
            this.g2.setClip(clip);
        } else {
            gs.CTM[2][0] = area.x;
            gs.CTM[2][1] = area.y - fh + area.height;
            this.drawImage(this.pageNumber, formImg, gs, false, "xf" + this.formNum, 0, -1);
            ++this.formNum;
        }
    }

    final void renderShape(Shape defaultClip, int fillType, PdfPaint strokeCol, PdfPaint fillCol, Stroke shapeStroke, Shape currentShape, float strokeOpacity, float fillOpacity) {
        boolean clipChanged = false;
        Shape clip = this.g2.getClip();
        Composite comp = this.g2.getComposite();
        if (fillType == 2 || fillType == 3) {
            block22: {
                if (fillCol.getRGB() != -1 && this.changeLineArtAndText && this.textColor != null && !fillCol.isPattern() && (this.currentItem == -1 || this.endItem == -1 || this.currentItem <= this.endItem) && this.checkColorThreshold(fillCol.getRGB())) {
                    fillCol = new PdfColor(this.textColor.getRed(), this.textColor.getGreen(), this.textColor.getBlue());
                }
                fillCol.setScaling(this.cropX, this.cropH, this.scaling, 0.0f, 0.0f);
                if (this.customColorHandler != null) {
                    this.customColorHandler.setPaint(this.g2, fillCol, this.pageNumber, this.isPrinting);
                } else if (PdfDecoder.Helper != null) {
                    PdfDecoder.Helper.setPaint(this.g2, fillCol, this.pageNumber, this.isPrinting);
                } else {
                    this.g2.setPaint(fillCol);
                }
                if (fillOpacity != 1.0f) {
                    this.g2.setComposite(AlphaComposite.getInstance(3, fillOpacity));
                }
                try {
                    double iw = currentShape.getBounds2D().getWidth();
                    double ih = currentShape.getBounds2D().getHeight();
                    if ((ih == 0.0 || iw == 0.0) && ((BasicStroke)this.g2.getStroke()).getLineWidth() <= 1.0f) {
                        this.g2.fillRect(currentShape.getBounds().x, currentShape.getBounds().y, currentShape.getBounds().width, currentShape.getBounds().height);
                    } else {
                        this.g2.fill(currentShape);
                    }
                }
                catch (Exception e) {
                    if (!LogWriter.isOutput()) break block22;
                    LogWriter.writeLog("Exception " + e + " filling shape");
                }
            }
            this.g2.setComposite(comp);
        }
        if (fillType == 1 || fillType == 3) {
            Stroke currentStroke = this.g2.getStroke();
            if (currentShape.getBounds2D().getWidth() < 1.0 && ((BasicStroke)shapeStroke).getLineWidth() > 10.0f) {
                this.g2.setStroke(new BasicStroke(1.0f));
            } else {
                this.g2.setStroke(shapeStroke);
            }
            if (this.changeLineArtAndText && this.textColor != null && !strokeCol.isPattern() && (this.currentItem == -1 || this.endItem == -1 || this.currentItem <= this.endItem) && this.checkColorThreshold(strokeCol.getRGB())) {
                strokeCol = new PdfColor(this.textColor.getRed(), this.textColor.getGreen(), this.textColor.getBlue());
            }
            strokeCol.setScaling(this.cropX, this.cropH, this.scaling, 0.0f, 0.0f);
            if (this.customColorHandler != null) {
                this.customColorHandler.setPaint(this.g2, strokeCol, this.pageNumber, this.isPrinting);
            } else if (PdfDecoder.Helper != null) {
                PdfDecoder.Helper.setPaint(this.g2, strokeCol, this.pageNumber, this.isPrinting);
            } else {
                this.g2.setPaint(strokeCol);
            }
            if (strokeOpacity != 1.0f) {
                this.g2.setComposite(AlphaComposite.getInstance(3, strokeOpacity));
            }
            if (!this.isPrinting && clip != null && (clip.getBounds2D().getHeight() < 1.0 || clip.getBounds2D().getWidth() < 1.0)) {
                this.g2.setClip(defaultClip);
                clipChanged = true;
            }
            this.g2.draw(currentShape);
            this.g2.setStroke(currentStroke);
            this.g2.setComposite(comp);
        }
        if (clipChanged) {
            this.g2.setClip(clip);
        }
    }

    final void renderImage(AffineTransform imageAf, BufferedImage image, float alpha, GraphicsState currentGraphicsState, float x, float y, int optionsApplied) {
        boolean isClipChanged;
        Shape clip;
        Composite c;
        AffineTransform before;
        block58: {
            boolean renderDirect;
            boolean bl = renderDirect = currentGraphicsState != null;
            if (image == null) {
                return;
            }
            int w = image.getWidth();
            int h = image.getHeight();
            AffineTransform upside_down = new AffineTransform();
            boolean applyTransform = false;
            float[][] CTM = new float[3][3];
            if (currentGraphicsState != null) {
                CTM = currentGraphicsState.CTM;
            }
            if (CTM[0][0] < 0.0f && CTM[1][1] < 0.0f && CTM[1][0] > -2.0f && CTM[1][0] < 0.0f && CTM[0][1] > 0.0f && CTM[0][1] < 10.0f) {
                CTM[0][1] = 0.0f;
                CTM[1][0] = 0.0f;
            }
            before = this.g2.getTransform();
            boolean invertInAff = false;
            float dx = 0.0f;
            float dy = 0.0f;
            if (renderDirect || this.useHiResImageForDisplay) {
                if (renderDirect) {
                    upside_down = null;
                    if ((optionsApplied & 1) != 1) {
                        float[][] rot;
                        Object flip2;
                        if (!this.optimisedTurnCode) {
                            image = RenderUtils.invertImage(CTM, image);
                        } else if (CTM[0][1] < 0.0f && CTM[1][0] > 0.0f && CTM[0][0] * CTM[1][1] == 0.0f) {
                            upside_down = new AffineTransform(CTM[0][0] / (float)w, CTM[0][1] / (float)w, -CTM[1][0] / (float)h, CTM[1][1] / (float)h, CTM[2][0] + CTM[1][0], CTM[2][1]);
                        } else if (CTM[0][1] < 0.0f || CTM[1][0] < 0.0f) {
                            flip2 = new float[][]{{1.0f / (float)w, 0.0f, 0.0f}, {0.0f, -1.0f / (float)h, 0.0f}, {0.0f, 1.0f / (float)h, 1.0f}};
                            rot = new float[][]{{CTM[0][0], CTM[0][1], 0.0f}, {CTM[1][0], CTM[1][1], 0.0f}, {0.0f, 0.0f, 1.0f}};
                            flip2 = Matrix.multiply(flip2, rot);
                            upside_down = new AffineTransform(flip2[0][0], flip2[0][1], flip2[1][0], flip2[1][1], flip2[2][0], flip2[2][1]);
                            dx = CTM[2][0] - (float)image.getHeight() * flip2[1][0];
                            dy = CTM[2][1];
                            dy += CTM[1][1];
                        } else if (CTM[0][0] * CTM[0][1] == 0.0f && CTM[1][1] * CTM[1][0] == 0.0f && CTM[0][1] > 0.0f && CTM[1][0] > 0.0f) {
                            flip2 = new float[][]{{-1.0f / (float)w, 0.0f, 0.0f}, {0.0f, 1.0f / (float)h, 0.0f}, {1.0f / (float)w, 0.0f, 1.0f}};
                            rot = new float[][]{{CTM[0][0], CTM[0][1], 0.0f}, {CTM[1][0], CTM[1][1], 0.0f}, {0.0f, 0.0f, 1.0f}};
                            flip2 = Matrix.multiply(flip2, rot);
                            upside_down = new AffineTransform(flip2[0][0], flip2[1][0], flip2[0][1], flip2[1][1], flip2[2][0], flip2[2][1]);
                            dx = CTM[2][0] - (float)image.getHeight() * flip2[0][1];
                            dy = CTM[2][1];
                        } else if (CTM[1][1] != 0.0f) {
                            invertInAff = true;
                        }
                    }
                    if (upside_down == null) {
                        upside_down = new AffineTransform(CTM[0][0] / (float)w, CTM[0][1] / (float)w, CTM[1][0] / (float)h, CTM[1][1] / (float)h, CTM[2][0], CTM[2][1]);
                    }
                } else {
                    upside_down = imageAf;
                    invertInAff = (optionsApplied & 4) == 4;
                }
                applyTransform = true;
            }
            c = this.g2.getComposite();
            clip = this.g2.getClip();
            isClipChanged = false;
            if (alpha != 1.0f) {
                this.g2.setComposite(AlphaComposite.getInstance(3, alpha));
            }
            if (this.isType3Font && this.fillCol != null) {
                int[] maskCol = new int[4];
                int foreground = this.fillCol.getRGB();
                maskCol[0] = foreground >> 16 & 0xFF;
                maskCol[1] = foreground >> 8 & 0xFF;
                maskCol[2] = foreground & 0xFF;
                maskCol[3] = 255;
                if (maskCol[0] != 0 || maskCol[1] != 0 || maskCol[2] != 0) {
                    if (image.getType() == 10 && maskCol[0] > 250 && maskCol[1] > 250 && maskCol[2] > 250) {
                        return;
                    }
                    BufferedImage img = new BufferedImage(image.getWidth(), image.getHeight(), image.getType());
                    WritableRaster src = image.getRaster();
                    WritableRaster dest = img.getRaster();
                    int[] values = new int[4];
                    for (int yy = 0; yy < image.getHeight(); ++yy) {
                        for (int xx = 0; xx < image.getWidth(); ++xx) {
                            src.getPixel(xx, yy, values);
                            if (values[3] <= 2) continue;
                            dest.setPixel(xx, yy, maskCol);
                        }
                    }
                    image = img;
                }
            }
            if (renderDirect || this.useHiResImageForDisplay) {
                try {
                    BufferedImage newImage;
                    boolean useCustomRenderer;
                    if (this.optimisedTurnCode && invertInAff && (optionsApplied & 1) != 1) {
                        double[] values = new double[6];
                        upside_down.getMatrix(values);
                        dx = (float)(values[4] + values[1] * (double)image.getWidth());
                        dy = (float)(values[5] + (double)image.getHeight() * values[3]);
                        if (values[0] > 0.0 && values[1] > 0.0 && values[2] > 0.0 && values[3] < 0.0) {
                            values[2] = -values[2];
                        }
                        values[3] = -values[3];
                        values[4] = 0.0;
                        values[5] = 0.0;
                        upside_down = new AffineTransform(values);
                    }
                    boolean bl2 = useCustomRenderer = this.customImageHandler != null;
                    if (useCustomRenderer) {
                        useCustomRenderer = this.customImageHandler.drawImageOnscreen(image, optionsApplied, upside_down, null, this.g2, renderDirect, this.objectStoreRef, this.isPrinting);
                    }
                    if (useCustomRenderer) {
                        this.g2.setComposite(c);
                        return;
                    }
                    this.g2.translate(dx, dy);
                    if (this.customColorHandler != null) {
                        BufferedImage newImage2 = this.customColorHandler.processImage(image, this.pageNumber, this.isPrinting);
                        if (newImage2 != null) {
                            image = newImage2;
                        }
                    } else if (PdfDecoder.Helper != null && (newImage = PdfDecoder.Helper.processImage(image, this.pageNumber, this.isPrinting)) != null) {
                        image = newImage;
                    }
                    Shape g2clip = this.g2.getClip();
                    boolean isClipReset = false;
                    if (g2clip != null) {
                        double cy = this.g2.getClip().getBounds2D().getY();
                        double ch = this.g2.getClip().getBounds2D().getHeight();
                        double diff = (double)image.getHeight() - ch;
                        if (diff < 0.0) {
                            diff = -diff;
                        }
                        if (diff > 0.0 && diff < 1.0 && cy < 0.0 && image.getHeight() > 1 && image.getHeight() < 10) {
                            int count;
                            PathIterator i = this.g2.getClip().getPathIterator(null);
                            for (count = 0; !i.isDone() && count < 6; ++count) {
                                i.next();
                            }
                            if (count < 6) {
                                double cx = this.g2.getClip().getBounds2D().getX();
                                double cw = this.g2.getClip().getBounds2D().getWidth();
                                this.g2.setClip(new Rectangle((int)cx, (int)cy, (int)cw, (int)ch));
                                isClipReset = false;
                            }
                        }
                    }
                    this.g2.drawImage(image, upside_down, null);
                    if (isClipReset) {
                        this.g2.setClip(g2clip);
                    }
                    break block58;
                }
                catch (Exception e) {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Exception: " + e.getMessage());
                    }
                    break block58;
                }
            }
            try {
                if (applyTransform) {
                    AffineTransformOp invert = new AffineTransformOp(upside_down, ColorSpaces.hints);
                    image = invert.filter(image, null);
                }
                this.g2.translate(x, y);
                if (this.optimisedTurnCode && (optionsApplied & 4) == 4) {
                    AffineTransform flip3;
                    AffineTransform flip2;
                    float[] flip = new float[]{1.0f, 0.0f, 0.0f, -1.0f, 0.0f, image.getHeight()};
                    if (this.pageRotation == 0) {
                        flip2 = new AffineTransform(flip);
                    } else if (this.pageRotation == 90) {
                        flip2 = new AffineTransform();
                        if (this.extraRot) {
                            flip2.rotate(Math.PI, 0.0, 0.0);
                        } else {
                            flip2.rotate(1.5707963267948966, 0.0, 0.0);
                        }
                        flip2.translate(-image.getWidth(), -image.getHeight());
                        flip = new float[]{-1.0f, 0.0f, 0.0f, 1.0f, image.getWidth(), 0.0f};
                        flip3 = new AffineTransform(flip);
                        flip2.concatenate(flip3);
                    } else if (this.pageRotation == 180) {
                        flip2 = new AffineTransform();
                        if (this.extraRot) {
                            flip2.rotate(Math.PI, 0.0, 0.0);
                        }
                        flip2.translate(-image.getWidth(), -image.getHeight());
                        flip = new float[]{-1.0f, 0.0f, 0.0f, 1.0f, image.getWidth(), 0.0f};
                        flip3 = new AffineTransform(flip);
                        flip2.concatenate(flip3);
                    } else {
                        flip2 = new AffineTransform();
                        if (this.extraRot) {
                            flip2.rotate(Math.PI, 0.0, 0.0);
                        } else {
                            flip2.rotate(4.71238898038469, 0.0, 0.0);
                        }
                        flip2.translate(-image.getWidth(), -image.getHeight());
                        flip = new float[]{-1.0f, 0.0f, 0.0f, 1.0f, image.getWidth(), 0.0f};
                        flip3 = new AffineTransform(flip);
                        flip2.concatenate(flip3);
                    }
                    this.g2.drawImage(image, flip2, null);
                } else {
                    this.g2.drawImage((Image)image, 0, 0, null);
                }
                this.g2.translate(-x, -y);
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block58;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        this.g2.setTransform(before);
        if (isClipChanged && DecoderOptions.isRunningOnMac && clip != null) {
            this.g2.setClip(clip);
        }
        this.g2.setComposite(c);
    }

    final void renderText(float x, float y, int type, Area transformedGlyph2, Rectangle textHighlight, PdfPaint strokePaint, PdfPaint textFillCol, float strokeOpacity, float fillOpacity) {
        Color col;
        Paint currentCol = this.g2.getPaint();
        Composite comp = this.g2.getComposite();
        if ((type & 2) == 2) {
            if (textFillCol != null) {
                if (this.textColor != null && (this.currentItem == -1 || this.endItem == -1 || this.currentItem <= this.endItem) && this.checkColorThreshold(textFillCol.getRGB())) {
                    textFillCol = new PdfColor(this.textColor.getRed(), this.textColor.getGreen(), this.textColor.getBlue());
                }
                textFillCol.setScaling(this.cropX, this.cropH, this.scaling, x, y);
            }
            if (this.customColorHandler != null) {
                this.customColorHandler.setPaint(this.g2, textFillCol, this.pageNumber, this.isPrinting);
            } else if (PdfDecoder.Helper != null) {
                PdfDecoder.Helper.setPaint(this.g2, textFillCol, this.pageNumber, this.isPrinting);
            } else {
                this.g2.setPaint(textFillCol);
            }
            if (fillOpacity != 1.0f) {
                this.g2.setComposite(AlphaComposite.getInstance(3, fillOpacity));
            }
            if (textHighlight != null) {
                if (invertHighlight) {
                    col = this.g2.getColor();
                    this.g2.setColor(new Color(255 - col.getRed(), 255 - col.getGreen(), 255 - col.getBlue()));
                } else if (DecoderOptions.backgroundColor != null) {
                    this.g2.setColor(DecoderOptions.backgroundColor);
                }
            }
            this.g2.fill(transformedGlyph2);
            this.g2.setComposite(comp);
        }
        if ((type & 1) == 1) {
            float lineWidth;
            if (strokePaint != null) {
                if (this.textColor != null && (this.currentItem == -1 || this.endItem == -1 || this.currentItem <= this.endItem) && this.checkColorThreshold(strokePaint.getRGB())) {
                    strokePaint = new PdfColor(this.textColor.getRed(), this.textColor.getGreen(), this.textColor.getBlue());
                }
                strokePaint.setScaling(this.cropX + (double)x, this.cropH + (double)y, this.scaling, x, y);
            }
            if (this.customColorHandler != null) {
                this.customColorHandler.setPaint(this.g2, strokePaint, this.pageNumber, this.isPrinting);
            } else if (PdfDecoder.Helper != null) {
                PdfDecoder.Helper.setPaint(this.g2, strokePaint, this.pageNumber, this.isPrinting);
            } else {
                this.g2.setPaint(strokePaint);
            }
            if (strokeOpacity != 1.0f) {
                this.g2.setComposite(AlphaComposite.getInstance(3, strokeOpacity));
            }
            if (textHighlight != null) {
                if (invertHighlight) {
                    col = this.g2.getColor();
                    this.g2.setColor(new Color(255 - col.getRed(), 255 - col.getGreen(), 255 - col.getBlue()));
                } else if (DecoderOptions.backgroundColor != null) {
                    this.g2.setColor(DecoderOptions.backgroundColor);
                }
            }
            if ((lineWidth = (float)(1.0 / this.g2.getTransform().getScaleX())) < 0.0f) {
                lineWidth = -lineWidth;
            }
            this.g2.setStroke(new BasicStroke(lineWidth));
            if (lineWidth < 0.1f) {
                this.g2.draw(transformedGlyph2);
            } else {
                this.g2.fill(transformedGlyph2);
            }
            this.g2.setComposite(comp);
        }
        this.g2.setPaint(currentCol);
    }

    @Override
    public ObjectStore getObjectStore() {
        return this.objectStoreRef;
    }

    @Override
    public void setHiResImageForDisplayMode(boolean useHiResImageForDisplay) {
        this.useHiResImageForDisplay = useHiResImageForDisplay;
    }

    @Override
    public void setScalingValues(double cropX, double cropH, float scaling) {
        this.cropX = cropX;
        this.cropH = cropH;
        this.scaling = scaling;
    }

    @Override
    public void setCustomImageHandler(ImageHandler customImageHandler) {
        this.customImageHandler = customImageHandler;
    }

    @Override
    public void setCustomColorHandler(ColorHandler colorController) {
        this.customColorHandler = colorController;
    }

    @Override
    public void resetOnColorspaceChange() {
    }

    @Override
    public void drawFontBounds(Rectangle newfontBB) {
    }

    @Override
    public void drawAffine(double[] afValues) {
    }

    @Override
    public void drawFontSize(int fontSize) {
    }

    @Override
    public void setLineWidth(int lineWidth) {
    }

    @Override
    public void stopClearOnNextRepaint(boolean flag) {
    }

    @Override
    public boolean hasObjectsBehind(float[][] CTM) {
        int h;
        boolean hasObject = false;
        int x = (int)CTM[2][0];
        int y = (int)CTM[2][1];
        int w = (int)CTM[0][0];
        if (w == 0) {
            w = (int)CTM[0][1];
        }
        if ((h = (int)CTM[1][1]) == 0) {
            h = (int)CTM[1][0];
        }
        if (h < 0) {
            y += h;
            h = y - h;
        }
        if (w < 0) {
            x += w;
            w = x - w;
        }
        Rectangle[] areas = this.areas.get();
        int count = areas.length;
        for (int i = 0; i < count; ++i) {
            boolean yOverlap;
            if (areas[i] == null) continue;
            int rx = areas[i].x;
            int ry = areas[i].y;
            int rw = areas[i].width;
            int rh = areas[i].height;
            boolean xOverlap = BaseDisplay.valueInRange(x, rx, rx + rw) || BaseDisplay.valueInRange(rx, x, x + w);
            boolean bl = yOverlap = xOverlap && BaseDisplay.valueInRange(y, ry, ry + rh) || BaseDisplay.valueInRange(ry, y, y + rh);
            if (!xOverlap || !yOverlap) continue;
            i = count;
            hasObject = true;
        }
        return hasObject;
    }

    private static boolean valueInRange(int value, int min, int max) {
        return value >= min && value <= max;
    }

    @Override
    public void flagDecodingFinished() {
    }

    @Override
    public void flagImageDeleted(int i) {
    }

    @Override
    public void setOCR(boolean isOCR) {
    }

    @Override
    public byte[] serializeToByteArray(Set fontsAlreadyOnClient) throws IOException {
        return new byte[0];
    }

    @Override
    public void checkFontSaved(Object glyph, String name, PdfFont currentFontData) {
    }

    @Override
    public Rectangle getArea(int i) {
        return null;
    }

    @Override
    public int isInsideImage(int x, int y) {
        return 0;
    }

    @Override
    public void saveImage(int id, String des, String type) {
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public int getObjectUnderneath(int x, int y) {
        return 0;
    }

    @Override
    public void setneedsVerticalInvert(boolean b) {
    }

    @Override
    public void setneedsHorizontalInvert(boolean b) {
    }

    @Override
    public void stopG2HintSetting(boolean isSet) {
    }

    @Override
    public void setPrintPage(int currentPrintPage) {
    }

    public void drawColor(PdfPaint currentCol, int type) {
    }

    @Override
    public void drawShape(Shape currentShape, GraphicsState currentGraphicsState, int cmd) {
    }

    @Override
    public void drawCustom(Object value) {
    }

    @Override
    public void drawEmbeddedText(float[][] Trm, int fontSize, PdfGlyph embeddedGlyph, Object javaGlyph, int type, GraphicsState gs, AffineTransform at, String glyf, PdfFont currentFontData, float glyfWidth) {
    }

    @Override
    public Rectangle paint(Rectangle[] highlights, AffineTransform viewScaling, Rectangle userAnnot) {
        return null;
    }

    @Override
    public void setMessageFrame(Container frame) {
    }

    @Override
    public void dispose() {
    }

    @Override
    public int drawImage(int pageNumber, BufferedImage image, GraphicsState currentGraphicsState, boolean alreadyCached, String name, int optionsApplied, int previousUse) {
        return -1;
    }

    @Override
    public void drawXForm(DynamicVectorRenderer dvr, GraphicsState gs) {
    }

    @Override
    public void drawFillColor(PdfPaint currentCol) {
    }

    @Override
    public void drawAdditionalObjectsOverPage(int[] type, Color[] colors, Object[] obj) throws PdfException {
    }

    @Override
    public void flushAdditionalObjOnPage() {
    }

    @Override
    public void setOptimsePainting(boolean optimsePainting) {
    }

    @Override
    public void flush() {
    }

    @Override
    public void drawText(float[][] Trm, String text, GraphicsState currentGraphicsState, float x, float y, Font javaFont) {
    }

    public Rectangle getCombinedAreas(Rectangle targetRectangle, boolean justText) {
        return null;
    }

    @Override
    public Rectangle getOccupiedArea() {
        return null;
    }

    @Override
    public void setGraphicsState(int fillType, float value) {
    }

    @Override
    public void drawStrokeColor(Paint currentCol) {
    }

    @Override
    public void drawTR(int value) {
    }

    @Override
    public void drawStroke(Stroke current) {
    }

    @Override
    public void drawClip(GraphicsState currentGraphicsState, Shape defaultClip, boolean alwaysDraw) {
    }

    @Override
    public void setOutputDir(String output_dir, String fileName, String pageAsString) {
    }

    @Override
    public void writeCustom(int key, Object value) {
    }

    @Override
    public void flagCommand(int commandID, int tokenNumber) {
    }

    @Override
    public void setTag(int formTag, String value) {
    }

    @Override
    public void setValue(int key, int i) {
        switch (key) {
            case 1: {
                this.backgroundColor = new Color(i);
                break;
            }
            case 2: {
                this.textColor = new Color(i);
                break;
            }
            case 3: {
                if (i > 0) {
                    this.changeLineArtAndText = true;
                    break;
                }
                this.changeLineArtAndText = false;
                break;
            }
            case 4: {
                this.colorThresholdToReplace = i;
            }
        }
    }

    @Override
    public void setValue(int key, String[] S) {
    }

    @Override
    public int getValue(int key) {
        return -1;
    }

    @Override
    public BufferedImage getSingleImagePattern() {
        return null;
    }

    @Override
    public void setBooleanValue(int includeJSFontResizingCode, boolean b) {
    }

    @Override
    public boolean isScalingControlledByUser() {
        return false;
    }

    @Override
    public boolean avoidDownSamplingImage() {
        return false;
    }

    @Override
    public boolean getBooleanValue(int encloseContentInDiv) {
        return false;
    }

    @Override
    public float getScaling() {
        return this.scaling;
    }

    @Override
    public void saveAdvanceWidth(String baseFontName, String s, int potentialWidth) {
    }

    public static int isRectangle(Shape bounds) {
        int count;
        PathIterator i = bounds.getPathIterator(null);
        for (count = 0; !i.isDone() && count < 8; ++count) {
            i.next();
        }
        return count;
    }

    @Override
    public Object getObjectValue(int id) {
        return null;
    }

    public static boolean isHTMLorSVG(DynamicVectorRenderer dvr) {
        return dvr.getType() == 4 || dvr.getType() == 5 || dvr.getType() == 7;
    }
}

