/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils;

import java.io.UnsupportedEncodingException;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.io.TextTokens;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.utils.LogWriter;

public class StringUtils {
    private static final int aInt = 97;
    private static final int zeroInt = 48;
    private static final int nineInt = 57;
    private static final int openSquareBracketInt = 91;
    private static final int closeSquareBracketInt = 93;
    private static final int openCurlyBracket = 40;
    private static final int closeCurlyBracket = 41;
    private static final int backSlashInt = 92;
    private static final int forwardSlashInt = 47;
    private static final int hashInt = 35;
    private static final int divideInt = 247;
    private static final int fullStopInt = 46;
    private static final int spaceInt = 32;
    private static final int percentInt = 37;
    private static final int minusInt = 45;
    private static final int underScoreInt = 95;
    private static final int backSlachInt = 92;
    private static final int nInt = 110;
    private static final int newLineInt = 10;
    private static final int plusInt = 43;
    private static final int pInt = 112;
    private static final int colonInt = 58;
    private static final int equalsInt = 61;
    private static final int cInt = 99;
    private static final int qInt = 113;
    private static String enc = System.getProperty("file.encoding");

    public static String toLowerCase(String str) {
        int len = str.length();
        char[] chars = str.toCharArray();
        boolean isChanged = false;
        for (int jj = 0; jj < len; ++jj) {
            char c = chars[jj];
            if (c <= '@' || c >= '[') continue;
            chars[jj] = c = (char)(c + 32);
            isChanged = true;
        }
        if (isChanged) {
            return String.copyValueOf(chars, 0, len);
        }
        return str;
    }

    public static String toUpperCase(String str) {
        int len = str.length();
        char[] chars = str.toCharArray();
        boolean isChanged = false;
        for (int jj = 0; jj < len; ++jj) {
            char c = chars[jj];
            if (c <= '`' || c >= '{') continue;
            chars[jj] = c = (char)(c - 32);
            isChanged = true;
        }
        if (isChanged) {
            return String.copyValueOf(chars, 0, len);
        }
        return str;
    }

    public static final String handleEscapeChars(String value) {
        int escapeChar = value.indexOf(92);
        while (escapeChar != -1) {
            char c = value.charAt(escapeChar + 1);
            if (c == 'n') {
                c = '\n';
            }
            value = value.substring(0, escapeChar) + c + value.substring(escapeChar + 2, value.length());
            escapeChar = value.indexOf(92);
        }
        return value;
    }

    public static final String convertHexChars(String value) {
        if (value == null) {
            return value;
        }
        int escapeChar = value.indexOf(35);
        if (escapeChar == -1) {
            return value;
        }
        StringBuilder newString = new StringBuilder();
        int length = value.length();
        for (int ii = 0; ii < length; ++ii) {
            char c = value.charAt(ii);
            if (c == '#') {
                int end;
                if ((end = ++ii + 2) > length) {
                    end = length;
                }
                String key = value.substring(ii, end);
                c = (char)Integer.parseInt(key, 16);
                ++ii;
                if (c == ' ') continue;
                newString.append(c);
                continue;
            }
            newString.append(c);
        }
        return newString.toString();
    }

    public static boolean isNumber(String textString) {
        byte[] data = StringUtils.toBytes(textString);
        int strLength = data.length;
        boolean isNumber = true;
        for (int j = 0; j < strLength; ++j) {
            if (data[j] >= 48 && data[j] <= 57 || data[j] == 46 || j == 0 && data[j] == 45) continue;
            isNumber = false;
            j = strLength;
        }
        return isNumber;
    }

    public static String[] remove(String[] fields, int i) {
        if (i < 0 || i > fields.length) {
            return fields;
        }
        String[] retArray = new String[fields.length - 1];
        int r = 0;
        for (int f = 0; f < fields.length; ++f) {
            if (f == i) continue;
            retArray[r++] = fields[f];
        }
        return retArray;
    }

    public static String makeHTMLNameSafe(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        char[] chrs = name.toCharArray();
        if (name.indexOf(37) != -1 || name.indexOf(32) != -1 || name.indexOf(46) != -1 || name.indexOf(43) != -1 || name.indexOf(58) != -1 || name.indexOf(61) != -1 || name.indexOf(47) != -1 || name.indexOf(92) != -1) {
            block10: for (int i = 0; i < chrs.length; ++i) {
                switch (chrs[i]) {
                    case ' ': {
                        chrs[i] = 95;
                        continue block10;
                    }
                    case '.': {
                        chrs[i] = 45;
                        continue block10;
                    }
                    case '%': {
                        chrs[i] = 95;
                        continue block10;
                    }
                    case '+': {
                        chrs[i] = 112;
                        continue block10;
                    }
                    case ':': {
                        chrs[i] = 99;
                        continue block10;
                    }
                    case '=': {
                        chrs[i] = 113;
                        continue block10;
                    }
                    case '/': {
                        chrs[i] = 95;
                        continue block10;
                    }
                    case '\\': {
                        chrs[i] = 95;
                    }
                }
            }
        }
        char[] testchrs = new char[]{'[', ']', '#', '\u00f7', '(', ')'};
        int count = 0;
        for (char chr1 : chrs) {
            for (char testchr : testchrs) {
                if (chr1 != testchr) continue;
                ++count;
            }
        }
        if (count > 0) {
            int c = 0;
            char[] tmp = new char[chrs.length - count];
            block13: for (char chr : chrs) {
                for (char testchr : testchrs) {
                    if (chr == testchr) continue block13;
                }
                tmp[c++] = chr;
            }
            chrs = tmp;
        }
        if (chrs[0] >= '0' && chrs[0] <= '9') {
            char[] tmp = new char[chrs.length + 1];
            System.arraycopy(chrs, 0, tmp, 1, chrs.length);
            tmp[0] = 97;
            chrs = tmp;
        }
        name = new String(chrs);
        return name;
    }

    public static String getTextString(byte[] rawText, boolean keepReturns) {
        String returnText = "";
        StandardFonts.checkLoaded(6);
        char[] chars = null;
        if (rawText != null) {
            chars = new char[rawText.length * 2];
        }
        int ii = 0;
        TextTokens rawChars = new TextTokens(rawText);
        if (rawChars.isUnicode()) {
            while (rawChars.hasMoreTokens()) {
                char nextChar = rawChars.nextUnicodeToken();
                if (nextChar == '\t') {
                    chars[ii] = 32;
                    ++ii;
                    continue;
                }
                if (nextChar <= '\u001f' && (!keepReturns || nextChar != '\n' && nextChar != '\r')) continue;
                chars[ii] = nextChar;
                ++ii;
            }
        } else {
            while (rawChars.hasMoreTokens()) {
                char nextChar = rawChars.nextToken();
                String c = null;
                if (nextChar == '\t') {
                    c = " ";
                } else if (keepReturns && (nextChar == '\n' || nextChar == '\r')) {
                    c = String.valueOf(nextChar);
                } else if (nextChar > '\u001f' && nextChar < '\u00fd') {
                    c = StandardFonts.getEncodedChar(6, nextChar);
                }
                if (c == null) continue;
                int len = c.length();
                if (ii + len >= chars.length) {
                    char[] tmp = new char[len + ii + 10];
                    System.arraycopy(chars, 0, tmp, 0, chars.length);
                    chars = tmp;
                }
                for (int i = 0; i < len; ++i) {
                    chars[ii] = c.charAt(i);
                    ++ii;
                }
            }
        }
        if (chars != null) {
            returnText = String.copyValueOf(chars, 0, ii);
            returnText = StringUtils.decodeUTF16String(returnText);
        }
        return returnText;
    }

    public static String decodeUTF16String(String source) {
        String copy = source.toUpperCase();
        if (copy.length() >= 4 && copy.length() % 2 == 0 && copy.startsWith("FEFF") && copy.matches("[0-9A-F]+")) {
            copy = copy.substring(4);
            byte[] content = new byte[copy.length() / 2];
            for (int i = 0; i < copy.length(); i += 2) {
                content[i / 2] = (byte)Integer.parseInt(copy.substring(i, i + 2), 16);
            }
            StringBuilder newString = new StringBuilder(content.length / 2);
            for (int i = 0; i < content.length; ++i) {
                if (content[i] == 0) continue;
                newString.append((char)content[i]);
            }
            return newString.toString();
        }
        return source;
    }

    public static String replaceAllManual(String string, int find, String replace) {
        int index = string.indexOf(find);
        while (index != -1) {
            string = string.substring(0, index) + replace + string.substring(index + 1);
            index = string.indexOf(find);
        }
        return string;
    }

    public static String correctSpecialChars(String string) {
        block32: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '\u00e1': {
                    string = StringUtils.replaceAllManual(string, 225, "&aacute;");
                    continue block32;
                }
                case '\u00e0': {
                    string = StringUtils.replaceAllManual(string, 224, "&agrave;");
                    continue block32;
                }
                case '\u00e2': {
                    string = StringUtils.replaceAllManual(string, 226, "&acirc;");
                    continue block32;
                }
                case '\u00e5': {
                    string = StringUtils.replaceAllManual(string, 229, "&aring;");
                    continue block32;
                }
                case '\u00e3': {
                    string = StringUtils.replaceAllManual(string, 227, "&atilde;");
                    continue block32;
                }
                case '\u00e4': {
                    string = StringUtils.replaceAllManual(string, 228, "&auml;");
                    continue block32;
                }
                case '\u00e6': {
                    string = StringUtils.replaceAllManual(string, 230, "&aelig;");
                    continue block32;
                }
                case '\u00e7': {
                    string = StringUtils.replaceAllManual(string, 231, "&ccedil;");
                    continue block32;
                }
                case '\u00e9': {
                    string = StringUtils.replaceAllManual(string, 233, "&eacute;");
                    continue block32;
                }
                case '\u00e8': {
                    string = StringUtils.replaceAllManual(string, 232, "&egrave;");
                    continue block32;
                }
                case '\u00ea': {
                    string = StringUtils.replaceAllManual(string, 234, "&ecirc;");
                    continue block32;
                }
                case '\u00eb': {
                    string = StringUtils.replaceAllManual(string, 235, "&euml;");
                    continue block32;
                }
                case '\u00ed': {
                    string = StringUtils.replaceAllManual(string, 237, "&iacute;");
                    continue block32;
                }
                case '\u00ec': {
                    string = StringUtils.replaceAllManual(string, 236, "&igrave;");
                    continue block32;
                }
                case '\u00ee': {
                    string = StringUtils.replaceAllManual(string, 238, "&icirc;");
                    continue block32;
                }
                case '\u00ef': {
                    string = StringUtils.replaceAllManual(string, 239, "&iuml;");
                    continue block32;
                }
                case '\u00f1': {
                    string = StringUtils.replaceAllManual(string, 241, "&ntilde;");
                    continue block32;
                }
                case '\u00f3': {
                    string = StringUtils.replaceAllManual(string, 243, "&oacute;");
                    continue block32;
                }
                case '\u00f2': {
                    string = StringUtils.replaceAllManual(string, 242, "&ograve;");
                    continue block32;
                }
                case '\u00f4': {
                    string = StringUtils.replaceAllManual(string, 244, "&ocirc;");
                    continue block32;
                }
                case '\u00f8': {
                    string = StringUtils.replaceAllManual(string, 248, "&oslash;");
                    continue block32;
                }
                case '\u00f5': {
                    string = StringUtils.replaceAllManual(string, 245, "&otilde;");
                    continue block32;
                }
                case '\u00f6': {
                    string = StringUtils.replaceAllManual(string, 246, "&ouml;");
                    continue block32;
                }
                case '\u00df': {
                    string = StringUtils.replaceAllManual(string, 223, "&szlig;");
                    continue block32;
                }
                case '\u00fa': {
                    string = StringUtils.replaceAllManual(string, 250, "&uacute;");
                    continue block32;
                }
                case '\u00f9': {
                    string = StringUtils.replaceAllManual(string, 249, "&ugrave;");
                    continue block32;
                }
                case '\u00fb': {
                    string = StringUtils.replaceAllManual(string, 251, "&ucirc;");
                    continue block32;
                }
                case '\u00fc': {
                    string = StringUtils.replaceAllManual(string, 252, "&uuml;");
                    continue block32;
                }
                case '\u00ff': {
                    string = StringUtils.replaceAllManual(string, 255, "&yuml;");
                    continue block32;
                }
                case '\u2019': {
                    string = StringUtils.replaceAllManual(string, 8217, "&#39;");
                }
            }
        }
        return string;
    }

    public static byte[] toBytes(String value) {
        byte[] data;
        block2: {
            data = null;
            try {
                data = value.getBytes(enc);
            }
            catch (UnsupportedEncodingException e) {
                if (!LogWriter.isOutput()) break block2;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        return data;
    }

    public static String makeMethodSafe(String S) {
        String name = StringUtils.makeHTMLNameSafe(S);
        name = name.replace("-", "_");
        return name;
    }

    public static String stripIllegalCharacters(String S) {
        String newString = "";
        for (int i = 0; i < S.length(); ++i) {
            char ch = S.charAt(i);
            if (ch < ' ' && ch >= '\u0000' || ch > '~' && ch < '\u00a0') continue;
            newString = newString + ch;
        }
        return newString;
    }

    static {
        if (!(enc.equals("UTF-8") || enc.equals("MacRoman") || enc.equals("Cp1252"))) {
            enc = DecoderOptions.isRunningOnMac ? "MacRoman" : (DecoderOptions.isRunningOnWindows ? "Cp1252" : "UTF-8");
        }
    }
}

