/*
 * Decompiled with CFR 0.152.
 */
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfSignatureAppearance;
import com.lowagie.text.pdf.PdfStamper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLDecoder;
import java.security.CodeSource;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import sun.security.pkcs11.SunPKCS11;

public class JPdfSign {
    private static PrivateKey privateKey;
    private static Certificate[] certificateChain;
    private static ResourceBundle bundle;
    private static String PRODUCTNAME;
    private static String VERSION;
    private static String JAR_FILENAME;

    public static void main(String[] args) {
        if (args.length < 2) {
            JPdfSign.showUsage();
        }
        try {
            String pkcs12FileName = args[0].trim();
            String pdfInputFileName = args[1];
            String pdfOutputFileName = args[2];
            boolean usePKCS12 = !pkcs12FileName.equals("-PKCS11");
            String passwdfile = "";
            if (args.length == 4) {
                passwdfile = args[3];
            }
            if (usePKCS12) {
                JPdfSign.readPrivateKeyFromPKCS12(pkcs12FileName, passwdfile);
            } else {
                JPdfSign.readPrivateKeyFromPKCS11();
            }
            PdfReader reader = null;
            try {
                reader = new PdfReader(pdfInputFileName);
            }
            catch (IOException e) {
                System.err.println("An unknown error accoured while opening the input PDF file: \"" + pdfInputFileName + "\"");
                e.printStackTrace();
                System.exit(-1);
            }
            FileOutputStream fout = null;
            try {
                fout = new FileOutputStream(pdfOutputFileName);
            }
            catch (FileNotFoundException e) {
                System.err.println("An unknown error accoured while opening the output PDF file: \"" + pdfOutputFileName + "\"");
                e.printStackTrace();
                System.exit(-1);
            }
            PdfStamper stp = null;
            try {
                stp = PdfStamper.createSignature(reader, fout, '\u0000', null, true);
                PdfSignatureAppearance sap = stp.getSignatureAppearance();
                sap.setCrypto(privateKey, certificateChain, null, PdfSignatureAppearance.WINCER_SIGNED);
                sap.setCertified(true);
                stp.close();
            }
            catch (Exception e) {
                System.err.println("An unknown error accoured while signing the PDF file:");
                e.printStackTrace();
                System.exit(-1);
            }
        }
        catch (KeyStoreException kse) {
            System.err.println("An unknown error accoured while initializing the KeyStore instance:");
            kse.printStackTrace();
            System.exit(-1);
        }
    }

    private static void readPrivateKeyFromPKCS11() throws KeyStoreException {
        String configFileName = JPdfSign.getConfigFilePath("pkcs11.cfg");
        SunPKCS11 p = null;
        try {
            p = new SunPKCS11(configFileName);
            Security.addProvider(p);
        }
        catch (ProviderException e) {
            System.err.println("Unable to load PKCS#11 provider with config file: " + configFileName);
            e.printStackTrace();
            System.exit(-1);
        }
        String pkcs11PIN = "000000";
        System.out.print("Please enter the smartcard pin: ");
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            pkcs11PIN = in.readLine();
        }
        catch (Exception e) {
            System.err.println("An unknown error accoured while reading the PIN:");
            e.printStackTrace();
            System.exit(-1);
        }
        KeyStore ks = null;
        try {
            ks = KeyStore.getInstance("pkcs11", p);
            ks.load(null, pkcs11PIN.toCharArray());
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println("An unknown error accoured while reading the PKCS#11 smartcard:");
            e.printStackTrace();
            System.exit(-1);
        }
        catch (CertificateException e) {
            System.err.println("An unknown error accoured while reading the PKCS#11 smartcard:");
            e.printStackTrace();
            System.exit(-1);
        }
        catch (IOException e) {
            System.err.println("An unknown error accoured while reading the PKCS#11 smartcard:");
            e.printStackTrace();
            System.exit(-1);
        }
        String alias = "";
        try {
            alias = ks.aliases().nextElement();
            privateKey = (PrivateKey)ks.getKey(alias, pkcs11PIN.toCharArray());
        }
        catch (NoSuchElementException e) {
            System.err.println("An unknown error accoured while retrieving the private key:");
            System.err.println("The selected PKCS#12 file does not contain any private keys.");
            e.printStackTrace();
            System.exit(-1);
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println("An unknown error accoured while retrieving the private key:");
            e.printStackTrace();
            System.exit(-1);
        }
        catch (UnrecoverableKeyException e) {
            System.err.println("An unknown error accoured while retrieving the private key:");
            e.printStackTrace();
            System.exit(-1);
        }
        certificateChain = ks.getCertificateChain(alias);
    }

    protected static void readPrivateKeyFromPKCS12(String pkcs12FileName, String pwdFile) throws KeyStoreException {
        String pkcs12Password = "";
        KeyStore ks = null;
        if (!pwdFile.equals("")) {
            try {
                FileInputStream pwdfis = new FileInputStream(pwdFile);
                byte[] pwd = new byte[1024];
                try {
                    int r;
                    while ((r = pwdfis.read(pwd)) >= 0) {
                        pkcs12Password = pkcs12Password + new String(pwd);
                        pkcs12Password = pkcs12Password.trim();
                        if (pwdfis.available() > 0) continue;
                    }
                    pwdfis.close();
                }
                catch (IOException ex) {
                    System.err.println("Can't read password file: " + pwdFile);
                }
            }
            catch (FileNotFoundException fnfex) {
                System.err.println("Password file not found: " + pwdFile);
            }
        } else {
            System.out.print("Please enter the password for \"" + pkcs12FileName + "\": ");
            try {
                BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
                pkcs12Password = in.readLine();
            }
            catch (Exception e) {
                System.err.println("An unknown error accoured while reading the password:");
                e.printStackTrace();
                System.exit(-1);
            }
        }
        try {
            ks = KeyStore.getInstance("pkcs12");
            ks.load(new FileInputStream(pkcs12FileName), pkcs12Password.toCharArray());
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println("An unknown error accoured while reading the PKCS#12 file:");
            e.printStackTrace();
            System.exit(-1);
        }
        catch (CertificateException e) {
            System.err.println("An unknown error accoured while reading the PKCS#12 file:");
            e.printStackTrace();
            System.exit(-1);
        }
        catch (FileNotFoundException e) {
            System.err.println("Unable to open the PKCS#12 keystore file \"" + pkcs12FileName + "\":");
            System.err.println("The file does not exists or missing read permission.");
            System.exit(-1);
        }
        catch (IOException e) {
            System.err.println("An unknown error accoured while reading the PKCS#12 file:");
            e.printStackTrace();
            System.exit(-1);
        }
        String alias = "";
        try {
            alias = ks.aliases().nextElement();
            privateKey = (PrivateKey)ks.getKey(alias, pkcs12Password.toCharArray());
        }
        catch (NoSuchElementException e) {
            System.err.println("An unknown error accoured while retrieving the private key:");
            System.err.println("The selected PKCS#12 file does not contain any private keys.");
            e.printStackTrace();
            System.exit(-1);
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println("An unknown error accoured while retrieving the private key:");
            e.printStackTrace();
            System.exit(-1);
        }
        catch (UnrecoverableKeyException e) {
            System.err.println("An unknown error accoured while retrieving the private key:");
            e.printStackTrace();
            System.exit(-1);
        }
        certificateChain = ks.getCertificateChain(alias);
    }

    protected static String getConfigFilePath(String configFilename) {
        CodeSource source = JPdfSign.class.getProtectionDomain().getCodeSource();
        URL url = source.getLocation();
        String jarPath = URLDecoder.decode(url.getFile());
        File f = new File(jarPath);
        try {
            jarPath = f.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!f.isDirectory()) {
            f = new File(jarPath);
            jarPath = f.getParent();
        }
        System.out.println(jarPath);
        if (jarPath.length() > 0) {
            return jarPath + File.separator + configFilename;
        }
        return configFilename;
    }

    public static void showUsage() {
        System.out.println("jPdfSign v" + VERSION + " by Jan Peter Stotz - jpstotz@gmx.de\n");
        System.out.println(PRODUCTNAME + " usage:");
        System.out.println("\nFor using a PKCS#12 (.p12) file as signature certificate and private key source:");
        System.out.print("\tjava -jar " + JAR_FILENAME);
        System.out.println(" pkcs12FileName pdfInputFileName pdfOutputFileName");
        System.out.println("\nFor using a PKCS#11 smartcard as signature certificate and private key source:");
        System.out.print("\tjava -jar" + JAR_FILENAME);
        System.out.println(" -PKCS11 pdfInputFileName pdfOutputFileName");
        System.exit(0);
    }

    static {
        bundle = ResourceBundle.getBundle("strings");
        PRODUCTNAME = bundle.getString("productname");
        VERSION = bundle.getString("version");
        JAR_FILENAME = bundle.getString("jar-filename");
    }
}

