odoo.define('entrivis_required_numeric.required_numeric', function (require) {
"use strict";

var BasicField = require('web.basic_fields');
var registry = require('web.field_registry');
var core = require('web.core');
var _t = core._t;

var FieldRequiredNumeric = BasicField.FieldInteger.extend({

    //--------------------------------------------------------------------------
    // Private
    //--------------------------------------------------------------------------

    /**
     * Format Numeric value
     * value must be greater then zero if numeric field is required
     */
    _setValue: function (value, options) {
        if (parseInt(value) !== 0) {
            return this._super.apply(this, arguments);
        } else if (this.mode === 'edit') {
            this.do_warn(false, _t('Value for "' + this.string + '" should be greater than 0'));
        }
    },

});

registry.add('required_numeric', FieldRequiredNumeric);

})