# Copyright 2017 Denis Leemann, Camptocamp SA
# License AGPL-3.0 or later (http://www.gnu.org/licenses/agpl.html).
from odoo import models, fields


class ProcurementGroup(models.Model):
    _inherit = "procurement.group"

    date_planned = fields.Date()

    def _get_stock_move_values(
        self,
        product_id,
        product_qty,
        product_uom,
        location_id,
        name,
        origin,
        values,
        group_id,
    ):
        res = super()._get_stock_move_values(
            product_id,
            product_qty,
            product_uom,
            location_id,
            name,
            origin,
            values,
            group_id,
        )
        if values.get("carrier_id"):
            res["carrier_id"] = values["carrier_id"]
        if values.get("partner_dest_id"):
            res["partner_id"] = values["partner_dest_id"]
        return res
