- After creating a new database or installing `queue_job` on an existing
  database, Odoo must be restarted for the runner to detect it.
- When Odoo shuts down normally, it waits for running jobs to finish.
  However, when the Odoo server crashes or is otherwise force-stopped,
  running jobs are interrupted while the runner has no chance to know
  they have been aborted. In such situations, jobs may remain in
  `started` or `enqueued` state after the Odoo server is halted. Since
  the runner has no way to know if they are actually running or not, and
  does not know for sure if it is safe to restart the jobs, it does not
  attempt to restart them automatically. Such stale jobs therefore fill
  the running queue and prevent other jobs to start. You must therefore
  requeue them manually, either from the Jobs view, or by running the
  following SQL statement *before starting Odoo*:

``` sql
update queue_job set state='pending' where state in ('started', 'enqueued')
```
