# Copyright 2021 Camptocamp SA (http://www.camptocamp.com)
# @author Simone Orsi <simahawk@gmail.com>
# License LGPL-3.0 or later (http://www.gnu.org/licenses/lgpl.html).

from odoo.http import request

from odoo.addons.base_rest.controllers.main import RestController


class ShopfloorController(RestController):
    def _process_endpoint(
        self,
        app_id,
        service_name,
        service_method_name,
        *args,
        collection=None,
        **kwargs
    ):
        """Wrapper for  `_process_method` call.

        Behavior is the same for the methods automatically
        generated by `rest.service.registration`.
        """
        collection = collection or request.env["shopfloor.app"].browse(app_id)
        # TODO: in base_rest `*args` is passed based on
        # the type of route (eg: /<int:id>/update)
        return self._process_method(
            service_name,
            service_method_name,
            *args,
            collection=collection,
            params=kwargs
        )
