# -*- coding: utf-8 -*-
from odoo import http
from odoo.http import request

import logging

_logger = logging.getLogger(__name__)


class SpryngSmsController(http.Controller):
    @http.route('/spryng_sms', auth='public', type='http', methods=['GET'])
    def spryng_sms_callback(self, ID, RECIPIENT, STATUS, REASONCODE, REFERENCE, ADDED, RESULTDATE, OPERATOR_STATUS_AT,
                            OPERATOR, **kwargs):
        user = request.httprequest.authorization.get('username')
        password = request.httprequest.authorization.get('password')
        user_check = request.env['ir.config_parameter'].sudo().get_param('spryng_sms.spryng_sms_user')
        password_check = request.env['ir.config_parameter'].sudo().get_param('spryng_sms.spryng_sms_password')
        if user != user_check or password != password_check or not password_check or not user_check:
            _logger.error(f"Authentication error for Spryng API. Spring ID: {ID}, Odoo SMS ID: {REFERENCE}")
            return "Authentication Failed"
        try:
            # Look for sms record and update it
            sms = request.env['sms.sms'].sudo().browse(int(REFERENCE))
            sms.update({
                'spryng_id': ID,
                'spryng_delivered': True if STATUS == '10' else False,
                'spryng_reason_code': REASONCODE,
                'spryng_operator_status_at': OPERATOR_STATUS_AT,
                'state': 'sent' if STATUS == '10' else 'error',
                'spryng_recipient': RECIPIENT,
                'spryng_reference': REFERENCE,
                'spryng_added': ADDED,
                'spryng_result_date': RESULTDATE,
                'spryng_operator': OPERATOR
            })
            if sms.state != 'sent':
                sms.action_generate_activity(
                    REASONCODE, sms.mail_message_id.model, sms.mail_message_id.res_id, sms)

            notifications = request.env['mail.notification'].sudo().search([
                ('notification_type', '=', 'sms'),
                ('sms_id', '=', sms.id),
                ], limit=1
            )
            if notifications:
                notifications.write({
                    'notification_status': 'sent' if STATUS == '10' else 'exception',
                    'failure_reason': REASONCODE
                })
                
        except Exception as e:
            _logger.error(f"Error in Spryng SMS callback: Spring ID: {ID}, Odoo SMS ID: {REFERENCE}")
        return ID
